/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.properties.PropertiesMarble;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarAttunementProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarConstellationProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarDiscoveryProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarRadianceProvider;
import hellfirepvp.astralsorcery.common.container.factory.CustomContainerProvider;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockAltar
extends BlockStarlightNetwork
implements CustomItemBlock {
    private final AltarType type;

    public BlockAltar(AltarType type) {
        super(PropertiesMarble.defaultMarble().harvestLevel(1).harvestTool(ToolType.PICKAXE));
        this.type = type;
    }

    public AltarType getAltarType() {
        return this.type;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileAltar altar;
        if (!world.func_201670_d() && player instanceof ServerPlayerEntity && (altar = MiscUtils.getTileAt((IBlockReader)world, pos, TileAltar.class, true)) != null) {
            CustomContainerProvider provider;
            switch (altar.getAltarType()) {
                case DISCOVERY: {
                    provider = new ContainerAltarDiscoveryProvider(altar);
                    if (ResearchHelper.getProgress(player, LogicalSide.SERVER).getTierReached().isThisLaterOrEqual(ProgressionTier.BASIC_CRAFT)) break;
                    ResearchManager.informCrafted(player, new ItemStack((IItemProvider)BlocksAS.ALTAR_DISCOVERY));
                    break;
                }
                case ATTUNEMENT: {
                    provider = new ContainerAltarAttunementProvider(altar);
                    break;
                }
                case CONSTELLATION: {
                    provider = new ContainerAltarConstellationProvider(altar);
                    break;
                }
                case RADIANCE: {
                    provider = new ContainerAltarRadianceProvider(altar);
                    break;
                }
                default: {
                    provider = null;
                }
            }
            if (provider != null) {
                provider.openFor((ServerPlayerEntity)player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof BlockAltar)) {
            TileAltar ta = MiscUtils.getTileAt((IBlockReader)worldIn, pos, TileAltar.class, true);
            if (ta != null && !worldIn.field_72995_K) {
                ItemUtils.dropInventory((IItemHandler)ta.getInventory(), worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        } else {
            TileAltar ta;
            AltarType thisType = ((BlockAltar)state.func_177230_c()).type;
            AltarType thatType = ((BlockAltar)newState.func_177230_c()).type;
            if (thisType != thatType && (ta = MiscUtils.getTileAt((IBlockReader)worldIn, pos, TileAltar.class, true)) != null) {
                ta.updateType(thatType, false);
            }
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileAltar().updateType(this.type, true);
    }
}

