/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.util.word.RandomWordGenerator;
import hellfirepvp.astralsorcery.common.constellation.BaseConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.Ingredient;

public class ConstellationGenerator {
    public static GeneratedConstellation generateRandom(long seed) {
        Random sRandom = new Random(seed);
        int stars = 5 + (sRandom.nextFloat() > 0.6f ? 1 : 0);
        return ConstellationGenerator.generateRandom(seed, stars);
    }

    public static GeneratedConstellation generateRandom(long seed, int stars) {
        Random sRandom = new Random(seed);
        String name = RandomWordGenerator.getGenerator().generateWord(seed, sRandom.nextFloat() > 0.6f ? 7 : 6);
        GeneratedConstellation cst = new GeneratedConstellation(name);
        ArrayList tmpStars = Lists.newArrayList();
        ArrayList tmpConnections = Lists.newArrayList();
        for (int i = 0; i < stars; ++i) {
            Point newPoint = ConstellationGenerator.pickStarPoint(sRandom, tmpStars, 6.0f);
            tmpStars.add(new StarLocation(newPoint.x, newPoint.y));
        }
        Iterator it = tmpStars.iterator();
        while (it.hasNext()) {
            StarLocation sl = (StarLocation)it.next();
            StarLocation other = ConstellationGenerator.findConnection(sRandom, sl, tmpStars, tmpConnections);
            if (other == null) {
                it.remove();
                continue;
            }
            tmpConnections.add(new StarConnection(sl, other));
        }
        tmpStars.forEach(s -> cst.addStar(s.x, s.y));
        tmpConnections.forEach(c -> {
            if (cst.getStars().contains(c.to) && cst.getStars().contains(c.from)) {
                cst.addConnection(c.from, c.to);
            }
        });
        return cst;
    }

    private static StarLocation findConnection(Random rand, StarLocation sl, List<StarLocation> stars, List<StarConnection> existingConnections) {
        ArrayList others = Lists.newArrayList(stars);
        others.remove(sl);
        if (others.isEmpty()) {
            return null;
        }
        Collections.shuffle(others, rand);
        block0: for (StarLocation other : others) {
            StarConnection conn = new StarConnection(sl, other);
            for (StarConnection otherConnection : existingConnections) {
                if (!ConstellationGenerator.intersect(conn, otherConnection)) continue;
                continue block0;
            }
            return other;
        }
        return null;
    }

    private static boolean intersect(StarConnection sc1, StarConnection sc2) {
        return ConstellationGenerator.isIntersecting(sc1, sc2.from.asPoint()) || ConstellationGenerator.isIntersecting(sc1, sc2.to.asPoint());
    }

    private static boolean isIntersecting(StarConnection part, Point p) {
        StarConnection originPart = new StarConnection(new StarLocation(0, 0), new StarLocation(part.to.x - part.from.x, part.to.y - part.from.y));
        Point originOffset = new Point(p.x - part.from.x, p.y - part.from.y);
        return ConstellationGenerator.cross(originPart.to.asPoint(), originOffset) < 0;
    }

    private static int cross(Point p1, Point p2) {
        return p1.x * p2.y - p2.x * p1.y;
    }

    private static Point pickStarPoint(Random rand, List<StarLocation> occupied, float minDst) {
        Point opt;
        block0: while (true) {
            opt = new Point(rand.nextInt(25), rand.nextInt(25));
            opt.translate(3, 3);
            for (StarLocation other : occupied) {
                if (!(opt.distance(other.asPoint()) < (double)minDst)) continue;
                continue block0;
            }
            break;
        }
        return opt;
    }

    public static class GeneratedConstellation
    extends BaseConstellation {
        private final String localizedName;

        private GeneratedConstellation(String localizedName) {
            this.localizedName = localizedName;
        }

        @Override
        public int getSortingId() {
            return 0;
        }

        @Override
        public String getSimpleName() {
            return this.localizedName;
        }

        @Override
        public String getTranslationKey() {
            return this.getSimpleName();
        }

        @Override
        public List<Ingredient> getConstellationSignatureItems() {
            return Collections.emptyList();
        }

        @Override
        public IConstellation addSignatureItem(Supplier<Ingredient> ingredient) {
            return this;
        }

        @Override
        public Color getConstellationColor() {
            return ColorsAS.CONSTELLATION_TYPE_WEAK;
        }

        @Override
        public boolean canDiscover(PlayerEntity player, PlayerProgress progress) {
            return true;
        }

        @Override
        public int compareTo(IConstellation o) {
            return 0;
        }
    }
}

