/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.BaseHandlerRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomMatcherRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.Level;

public abstract class CustomRecipeBuilder<R extends CustomMatcherRecipe> {
    private static final Map<IRecipeType<?>, Set<ResourceLocation>> builtRecipes = new HashMap();

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, null);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, @Nullable String directory) {
        R recipe = this.validateAndGet();
        String saveId = ((BaseHandlerRecipe)recipe).func_199560_c().func_110623_a();
        if (directory != null) {
            saveId = directory + "/" + saveId;
        }
        saveId = this.getSerializer().getRegistryName().func_110623_a() + "/" + saveId;
        ResourceLocation id = new ResourceLocation(((BaseHandlerRecipe)recipe).func_199560_c().func_110624_b(), saveId);
        if (!builtRecipes.computeIfAbsent(recipe.func_222127_g(), type -> new HashSet()).add(id)) {
            throw new IllegalArgumentException("Tried to register recipe with id " + id + " twice for type " + Registry.field_218367_H.func_177774_c((Object)recipe.func_222127_g()));
        }
        consumerIn.accept(new WrappedCustomRecipe(this, (CustomMatcherRecipe)recipe, id));
    }

    @Nonnull
    protected abstract R validateAndGet();

    protected abstract CustomRecipeSerializer<R> getSerializer();

    private static class WrappedCustomRecipe
    implements IFinishedRecipe {
        private final R recipe;
        private final ResourceLocation id;
        final /* synthetic */ CustomRecipeBuilder this$0;

        private WrappedCustomRecipe(R recipe, ResourceLocation id) {
            this.this$0 = var1_1;
            this.recipe = recipe;
            this.id = id;
        }

        public void func_218610_a(JsonObject json) {
            AstralSorcery.log.log(Level.INFO, this.id.toString());
            this.this$0.getSerializer().write(json, this.recipe);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ((CustomMatcherRecipe)this.recipe).getSerializer();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("");
        }
    }
}

