/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.fountain;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.impl.RenderOffsetNoisePlane;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingSprite;
import hellfirepvp.astralsorcery.client.effect.vfx.FXSpritePlane;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrime;
import hellfirepvp.astralsorcery.common.crafting.nojson.fountain.FountainEffect;
import hellfirepvp.astralsorcery.common.crafting.nojson.fountain.VortexContext;
import hellfirepvp.astralsorcery.common.data.config.registry.TechnicalEntityRegistry;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperEntityFreeze;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileFountain;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class FountainEffectVortex
extends FountainEffect<VortexContext> {
    public FountainEffectVortex() {
        super(AstralSorcery.key("effect_vortex"));
    }

    @Override
    @Nonnull
    public BlockFountainPrime getAssociatedPrime() {
        return BlocksAS.FOUNTAIN_PRIME_VORTEX;
    }

    @Override
    @Nonnull
    public VortexContext createContext(TileFountain fountain) {
        return new VortexContext();
    }

    @Override
    public void tick(TileFountain fountain, VortexContext context, int operationTick, LogicalSide side, FountainEffect.OperationSegment currentSegment) {
        if (side.isClient()) {
            this.tickEffects(fountain, context, operationTick, currentSegment);
        } else if (side.isServer() && currentSegment.isLaterOrEqualTo(FountainEffect.OperationSegment.RUNNING)) {
            this.pullEntities(fountain);
        }
    }

    private void pullEntities(TileFountain fountain) {
        Vector3 at = new Vector3(fountain).add(0.5, 0.5, 0.5);
        Vector3 vortexAt = at.clone().addY(-4.0);
        AxisAlignedBB captureBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(fountain.func_174877_v().func_177979_c(4)).func_186662_g(2.0);
        AxisAlignedBB pullBox = captureBox.func_186662_g(14.0);
        float boxCapacity = 125.0f;
        float density = 0.0f;
        List captured = fountain.func_145831_w().func_217357_a(LivingEntity.class, captureBox);
        for (LivingEntity le : captured) {
            if (le == null || !le.func_70089_S() || le instanceof PlayerEntity || !TechnicalEntityRegistry.INSTANCE.canAffect((Entity)le)) continue;
            float entitySize = le.func_213302_cg() * le.func_213311_cf() * le.func_213311_cf();
            density += entitySize;
            if (entitySize > boxCapacity) {
                Vector3 heldPos = vortexAt.clone().addY(-1.0);
                if (heldPos.distanceSquared((Entity)le) >= (double)0.4f) {
                    le.func_70080_a(heldPos.getX(), heldPos.getY(), heldPos.getZ(), le.field_70177_z, le.field_70125_A);
                }
                if (le instanceof EnderDragonEntity) {
                    GameRules rules = fountain.func_145831_w().func_82736_K();
                    boolean prev = rules.func_223586_b(GameRules.field_223599_b);
                    ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223599_b)).func_223570_a(false, null);
                    le.func_70636_d();
                    ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223599_b)).func_223570_a(prev, null);
                }
            } else {
                le.func_213317_d(Vector3d.field_186680_a);
            }
            EventHelperEntityFreeze.freeze((Entity)le);
        }
        float upkeep = Math.max(0.0f, density / boxCapacity);
        fountain.consumeLiquidStarlight(MathHelper.func_76123_f((float)(upkeep / 3.0f)));
        List pulling = fountain.func_145831_w().func_217357_a(LivingEntity.class, pullBox);
        pulling.removeAll(captured);
        for (LivingEntity le : pulling) {
            if (le == null || !le.func_70089_S() || le instanceof PlayerEntity || !TechnicalEntityRegistry.INSTANCE.canAffect((Entity)le)) continue;
            EventHelperEntityFreeze.freeze((Entity)le);
            EntityUtils.applyVortexMotion(() -> Vector3.atEntityCorner((Entity)le), v -> {
                if (le instanceof EnderDragonEntity) {
                    Vector3 nextPos = Vector3.atEntityCorner((Entity)le).add((Vector3)v);
                    if (le.func_70613_aW()) {
                        le.func_70634_a(nextPos.getX(), nextPos.getY(), nextPos.getZ());
                    } else {
                        le.func_70080_a(nextPos.getX(), nextPos.getY(), nextPos.getZ(), le.field_70177_z, le.field_70125_A);
                    }
                    le.func_213317_d(Vector3d.field_186680_a);
                } else {
                    le.func_213317_d(le.func_213322_ci().func_72441_c(v.getX(), v.getY() * 2.5, v.getZ()));
                    le.field_70133_I = true;
                }
            }, vortexAt, 48.0, 3.0);
            if (!(vortexAt.distanceSquared((Entity)le) <= 16.0)) continue;
            Vector3 randomRanges = new Vector3(Math.max(0.0, (captureBox.func_216364_b() - (double)le.func_213311_cf()) / 2.0), Math.max(0.0, (captureBox.func_216360_c() - (double)le.func_213302_cg()) / 2.0), Math.max(0.0, (captureBox.func_216362_d() - (double)le.func_213311_cf()) / 2.0));
            Vector3 randomPos = vortexAt.clone().add(randomRanges.getX() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1), randomRanges.getY() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1), randomRanges.getZ() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1));
            le.func_70080_a(randomPos.getX(), randomPos.getY(), randomPos.getZ(), le.field_70177_z, le.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffects(TileFountain fountain, VortexContext ctx, int operationTick, FountainEffect.OperationSegment currentSegment) {
        if (currentSegment.isLaterOrEqualTo(FountainEffect.OperationSegment.STARTUP)) {
            FXSpritePlane sprite = (FXSpritePlane)ctx.fountainSprite;
            if (sprite == null) {
                sprite = (FXSpritePlane)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXSpritePlane)EffectHelper.of(EffectTemplatesAS.TEXTURE_SPRITE).spawn(new Vector3(fountain).add(0.5, 0.5, 0.5))).setAxis(Vector3.RotAxis.Y_AXIS).setNoRotation(45.0f).setSprite(SpritesAS.SPR_FOUNTAIN_VORTEX).setAlphaMultiplier(1.0f)).alpha((fx, alphaIn, pTicks) -> this.getSegmentPercent(FountainEffect.OperationSegment.STARTUP, fountain.getTickActiveFountainEffect()))).setScaleMultiplier(5.5f)).refresh(RefreshFunction.tileExistsAnd(fountain, (tile, fx) -> tile.getCurrentEffect() == this));
            } else if (sprite.isRemoved() || sprite.canRemove()) {
                EffectHelper.refresh(sprite, EffectTemplatesAS.TEXTURE_SPRITE);
            }
            ctx.fountainSprite = sprite;
        }
        BlockPos fountainPos = fountain.func_174877_v();
        float segmentPercent = this.getSegmentPercent(currentSegment, operationTick);
        switch (currentSegment) {
            case STARTUP: {
                this.playFountainVortexParticles((Vector3i)fountainPos, segmentPercent);
                this.playFountainArcs((Vector3i)fountainPos, segmentPercent);
                this.playCoreParticles(fountainPos, segmentPercent);
                break;
            }
            case PREPARATION: {
                this.playFountainArcs((Vector3i)fountainPos, 1.0f - segmentPercent);
                this.playFountainVortexParticles((Vector3i)fountainPos, 1.0f - segmentPercent);
                this.playCoreParticles(fountainPos, 1.0f - segmentPercent * 2.0f);
                this.playCorePrimerParticles(fountainPos, segmentPercent);
                break;
            }
            case RUNNING: {
                this.playFountainVortexParticles((Vector3i)fountainPos, 0.2f);
                this.playFountainArcs((Vector3i)fountainPos, 0.6f);
                this.playFountainVortexLowerParticles(fountainPos);
                this.playVortexEffects(fountainPos, fountain, ctx);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playVortexEffects(BlockPos pos, TileFountain fountain, VortexContext ctx) {
        Vector3 at = new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5);
        Vector3 vortexAt = at.clone().addY(-4.0);
        FXFacingSprite sprite = (FXFacingSprite)ctx.facingVortexPlane;
        if (sprite == null) {
            sprite = (FXFacingSprite)((EntityComplexFX)((EntityVisualFX)((FXFacingSprite)EffectHelper.of(EffectTemplatesAS.FACING_SPRITE).spawn(vortexAt)).setSprite(SpritesAS.SPR_ATTUNEMENT_FLARE).setAlphaMultiplier(1.0f)).setScaleMultiplier(2.0f)).refresh(RefreshFunction.tileExistsAnd(fountain, (tile, fx) -> tile.getCurrentEffect() == this));
        } else if (sprite.isRemoved() || sprite.canRemove()) {
            EffectHelper.refresh(sprite, EffectTemplatesAS.FACING_SPRITE);
        }
        ctx.facingVortexPlane = sprite;
        if (ctx.ctrlEffectNoise == null) {
            ctx.ctrlEffectNoise = Lists.newArrayList((Object[])new Object[]{new RenderOffsetNoisePlane(1.2f), new RenderOffsetNoisePlane(2.0f), new RenderOffsetNoisePlane(2.8f)});
        }
        for (Object objPlane : ctx.ctrlEffectNoise) {
            RenderOffsetNoisePlane plane = (RenderOffsetNoisePlane)objPlane;
            for (int i = 0; i < 3; ++i) {
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)plane.createParticle(vortexAt).setMotion(Vector3.random().normalize().multiply(0.005f))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(30 + rand.nextInt(15));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playFountainVortexLowerParticles(BlockPos pos) {
        int i;
        Vector3 at = new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5);
        Vector3 coreAt = at.clone().addY(-1.15);
        Vector3 vortexAt = at.clone().addY(-4.0);
        for (i = 0; i < 2; ++i) {
            ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(coreAt)).setScaleMultiplier(0.25f)).setAlphaMultiplier(1.0f)).setMotion(Vector3.random().normalize().multiply(0.01f))).color(VFXColorFunction.random());
        }
        for (i = 0; i < 3; ++i) {
            Vector3 spawnPos = vortexAt.clone().add(Vector3.random().multiply(4.5f));
            Vector3 dir = spawnPos.clone().vectorFromHereTo(vortexAt).normalize().divide(20 + rand.nextInt(10));
            ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(spawnPos)).setMotion(dir)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setAlphaMultiplier(1.0f)).color(VFXColorFunction.WHITE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playCorePrimerParticles(BlockPos pos, float chance) {
        float yOffset = -3.5f * Math.min(1.0f, chance * 2.0f);
        for (int i = 0; i < 15; ++i) {
            Vector3 at = new Vector3((double)pos.func_177958_n() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2, (double)((float)pos.func_177956_o() + yOffset - 0.1f) + (double)rand.nextFloat() * 0.2, (double)pos.func_177952_p() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2);
            float mul = chance <= 0.5f ? 1.0f : 1.0f - chance;
            Vector3 dir = new Vector3((double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setMotion(dir)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMaxAge(20 + rand.nextInt(40));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playCoreParticles(BlockPos pos, float chance) {
        Vector3 at = new Vector3((Vector3i)pos).add(0.5, -0.5, 0.5);
        for (int i = 0; i < 18; ++i) {
            if (rand.nextFloat() >= chance) continue;
            Vector3 particlePos = new Vector3((double)((float)(pos.func_177958_n() - 1) + rand.nextFloat() * 3.0f), (double)pos.func_177956_o() - 1.5 + (double)(rand.nextFloat() * 2.0f), (double)((float)(pos.func_177952_p() - 1) + rand.nextFloat() * 3.0f));
            Vector3 motion = particlePos.clone().vectorFromHereTo(at).normalize().divide(30.0);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(particlePos)).setMotion(motion)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMaxAge(20 + rand.nextInt(40));
        }
    }

    @Override
    public void transition(TileFountain fountain, VortexContext context, LogicalSide side, FountainEffect.OperationSegment prevSegment, FountainEffect.OperationSegment nextSegment) {
        if (side.isClient() && nextSegment == FountainEffect.OperationSegment.RUNNING) {
            this.doVortexExplosion(fountain.func_174877_v());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doVortexExplosion(BlockPos pos) {
        for (int i = 0; i < 140; ++i) {
            Vector3 at = new Vector3((float)pos.func_177958_n() + 0.5f - 0.1f + rand.nextFloat() * 0.2f, (float)pos.func_177956_o() - 3.5f - 0.1f + rand.nextFloat() * 0.2f, (float)pos.func_177952_p() + 0.5f - 0.1f + rand.nextFloat() * 0.2f);
            Vector3 dir = new Vector3((double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setMotion(dir)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMaxAge(20 + rand.nextInt(40));
        }
    }

    @Override
    public void onReplace(TileFountain fountain, VortexContext ctx, @Nullable FountainEffect<?> newEffect, LogicalSide side) {
        if (side.isClient()) {
            this.removeSprite(ctx);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeSprite(VortexContext ctx) {
        FXSpritePlane sprite = (FXSpritePlane)ctx.fountainSprite;
        if (sprite != null) {
            sprite.requestRemoval();
        }
    }
}

