/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.AttunementUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseAverageStatsRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseItemRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseMergeStatsRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseNBTCopyRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationCopyStatsRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationItemRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.CrystalCountRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.NBTCopyRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.TraitUpgradeRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeTypeHandler {
    public static final Type<AttunementUpgradeRecipe> ALTAR_UPGRADE_ATTUNEMENT = new Type(AstralSorcery.key("attunement_upgrade"));
    public static final Type<ConstellationUpgradeRecipe> ALTAR_UPGRADE_CONSTELLATION = new Type(AstralSorcery.key("constellation_upgrade"));
    public static final Type<TraitUpgradeRecipe> ALTAR_UPGRADE_TRAIT = new Type(AstralSorcery.key("trait_upgrade"));
    public static final Type<ConstellationBaseAverageStatsRecipe> CONSTELLATION_CRYSTAL_AVERAGE = new Type(AstralSorcery.key("constellation_base_average"));
    public static final Type<ConstellationBaseMergeStatsRecipe> CONSTELLATION_CRYSTAL_MERGE = new Type(AstralSorcery.key("constellation_base_merge"));
    public static final Type<ConstellationBaseItemRecipe> CONSTELLATION_ITEM_BASE = new Type(AstralSorcery.key("constellation_base"));
    public static final Type<ConstellationItemRecipe> CONSTELLATION_ITEM = new Type(AstralSorcery.key("constellation_item"));
    public static final Type<CrystalCountRecipe> CRYSTAL_SET_COUNT = new Type(AstralSorcery.key("crystal_count"));
    public static final Type<ConstellationBaseNBTCopyRecipe> CONSTELLATION_BASE_NBT_COPY = new Type(AstralSorcery.key("constellation_base_nbt_copy"));
    public static final Type<ConstellationCopyStatsRecipe> CONSTELLATION_COPY_CRYSTAL = new Type(AstralSorcery.key("constellation_copy_stats"));
    public static final Type<NBTCopyRecipe> NBT_COPY = new Type(AstralSorcery.key("nbt_copy"));
    public static final Type<SimpleAltarRecipe> DEFAULT = new Type(AstralSorcery.key("default"));
    private static final Map<ResourceLocation, Type<?>> CONVERTER_MAP = new HashMap();

    public static <T extends SimpleAltarRecipe> Type<T> registerConverter(ResourceLocation name, Function<SimpleAltarRecipe, T> converter) {
        Type type = new Type(name, converter);
        CONVERTER_MAP.put(name, type);
        return type;
    }

    private static <T extends SimpleAltarRecipe> void registerInternal(Type<T> type, Function<SimpleAltarRecipe, T> converter) {
        ((Type)type).converter = converter;
        CONVERTER_MAP.put(((Type)type).key, type);
    }

    public static <T extends SimpleAltarRecipe> T convert(SimpleAltarRecipe recipe, ResourceLocation alternativeBase) {
        return (T)CONVERTER_MAP.getOrDefault(alternativeBase, DEFAULT).convert(recipe);
    }

    public static void init() {
        AltarRecipeTypeHandler.registerInternal(ALTAR_UPGRADE_ATTUNEMENT, AttunementUpgradeRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(ALTAR_UPGRADE_CONSTELLATION, ConstellationUpgradeRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(ALTAR_UPGRADE_TRAIT, TraitUpgradeRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_CRYSTAL_AVERAGE, ConstellationBaseAverageStatsRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_CRYSTAL_MERGE, ConstellationBaseMergeStatsRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_ITEM_BASE, ConstellationBaseItemRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_ITEM, ConstellationItemRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CRYSTAL_SET_COUNT, CrystalCountRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_BASE_NBT_COPY, ConstellationBaseNBTCopyRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(CONSTELLATION_COPY_CRYSTAL, ConstellationCopyStatsRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(NBT_COPY, NBTCopyRecipe::convertToThis);
        AltarRecipeTypeHandler.registerInternal(DEFAULT, Function.identity());
    }

    public static class Type<T extends SimpleAltarRecipe> {
        private final ResourceLocation key;
        private Function<SimpleAltarRecipe, T> converter;

        private Type(ResourceLocation key) {
            this.key = key;
        }

        private Type(ResourceLocation key, Function<SimpleAltarRecipe, T> converter) {
            this.key = key;
            this.converter = converter;
        }

        public T convert(SimpleAltarRecipe recipe) {
            return (T)((SimpleAltarRecipe)this.converter.apply(recipe));
        }

        public final ResourceLocation getKey() {
            return this.key;
        }
    }
}

