/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeTypeHandler;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.AltarRecipeEffect;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class SimpleAltarRecipeSerializer
extends CustomRecipeSerializer<SimpleAltarRecipe> {
    public SimpleAltarRecipeSerializer() {
        super(RecipeSerializersAS.SIMPLE_ALTAR_CRAFTING);
    }

    public SimpleAltarRecipe read(ResourceLocation recipeId, JsonObject json) {
        JsonElement element;
        int typeId = JSONUtils.func_151203_m((JsonObject)json, (String)"altar_type");
        AltarType type = MiscUtils.getEnumEntry(AltarType.class, typeId);
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        int starlightRequirement = JSONUtils.func_151203_m((JsonObject)json, (String)"starlight");
        AltarRecipeGrid grid = AltarRecipeGrid.deserialize(type, json);
        grid.validate(type);
        SimpleAltarRecipe recipe = new SimpleAltarRecipe(recipeId, type, duration, starlightRequirement, grid);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"recipe_class")) {
            ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"recipe_class"));
            recipe = AltarRecipeTypeHandler.convert(recipe, key);
            recipe.setCustomRecipeType(key);
        }
        if (JSONUtils.func_151202_d((JsonObject)json, (String)"output")) {
            JsonArray outputArray = JSONUtils.func_151214_t((JsonObject)json, (String)"output");
            for (int i = 0; i < outputArray.size(); ++i) {
                recipe.addOutput(JsonHelper.getItemStack(outputArray.get(i), String.format("output[%s]", i)));
            }
        } else {
            recipe.addOutput(JsonHelper.getItemStack(json, "output"));
        }
        JsonObject recipeOptions = new JsonObject();
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"options")) {
            recipeOptions = JSONUtils.func_152754_s((JsonObject)json, (String)"options");
        }
        recipe.deserializeAdditionalJson(recipeOptions);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"focus_constellation")) {
            ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"focus_constellation"));
            IConstellation cst = (IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(key);
            if (cst == null) {
                throw new JsonSyntaxException("Unknown constellation " + key.toString());
            }
            recipe.setFocusConstellation(cst);
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"relay_inputs")) {
            JsonArray relayIngredients = JSONUtils.func_151214_t((JsonObject)json, (String)"relay_inputs");
            for (int i = 0; i < relayIngredients.size(); ++i) {
                element = relayIngredients.get(i);
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)element);
                if (!ingredient.func_203189_d()) {
                    recipe.addRelayInput(ingredient);
                    continue;
                }
                AstralSorcery.log.warn("Skipping relay_inputs[" + i + "] for recipe " + recipeId + " as the ingredient has no matching items!");
                AstralSorcery.log.warn("Ingredient skipped: " + JSONUtils.func_151222_d((JsonElement)element));
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"effects")) {
            JsonArray effectNames = JSONUtils.func_151214_t((JsonObject)json, (String)"effects");
            for (int i = 0; i < effectNames.size(); ++i) {
                element = effectNames.get(i);
                ResourceLocation effectKey = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)("effects[" + i + "]")));
                AltarRecipeEffect effect = (AltarRecipeEffect)RegistriesAS.REGISTRY_ALTAR_EFFECTS.getValue(effectKey);
                if (effect == null) {
                    throw new JsonSyntaxException("No altar effect for name " + effectKey + "! (Found at: effects[" + i + "])");
                }
                recipe.addAltarEffect(effect);
            }
        }
        return recipe;
    }

    public SimpleAltarRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        return SimpleAltarRecipe.read(recipeId, buffer);
    }

    @Override
    public void write(JsonObject object, SimpleAltarRecipe recipe) {
        recipe.write(object);
    }

    public void write(PacketBuffer buffer, SimpleAltarRecipe recipe) {
        recipe.write(buffer);
    }
}

