/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.journal;

import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageAltarRecipe;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageRecipe;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageText;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.data.journal.JournalPage;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JournalPageRecipe
implements JournalPage {
    private final Supplier<IRecipe<?>> recipeProvider;

    private JournalPageRecipe(Supplier<IRecipe<?>> recipeProvider) {
        this.recipeProvider = recipeProvider;
    }

    public static JournalPageRecipe fromName(ResourceLocation recipeId) {
        return new JournalPageRecipe(() -> {
            RecipeManager mgr = RecipeHelper.getRecipeManager();
            if (mgr == null) {
                throw new IllegalStateException("Not connected to a server, but calling GUI code?");
            }
            IRecipe recipe = (IRecipe)mgr.func_215366_a(RecipeTypesAS.TYPE_ALTAR.getType()).get(recipeId);
            if (recipe != null) {
                return recipe;
            }
            recipe = (IRecipe)mgr.func_215366_a(IRecipeType.field_222149_a).get(recipeId);
            if (recipe != null) {
                return recipe;
            }
            return null;
        });
    }

    public static JournalPageRecipe fromOutputPreferAltarRecipes(Predicate<ItemStack> outputTest) {
        return new JournalPageRecipe(() -> {
            RecipeManager mgr = RecipeHelper.getRecipeManager();
            if (mgr == null) {
                throw new IllegalStateException("Not connected to a server, but calling GUI code?");
            }
            IRecipe recipe = mgr.func_215366_a(RecipeTypesAS.TYPE_ALTAR.getType()).values().stream().map(r -> (SimpleAltarRecipe)r).filter(r -> outputTest.test(r.getOutputForRender(Collections.emptyList()))).findFirst().orElse(null);
            if (recipe != null) {
                return recipe;
            }
            recipe = mgr.func_215366_a(IRecipeType.field_222149_a).values().stream().filter(r -> outputTest.test(r.func_77571_b())).findFirst().orElse(null);
            if (recipe != null) {
                return recipe;
            }
            return null;
        });
    }

    public static JournalPageRecipe fromOutputPreferVanillaRecipes(Predicate<ItemStack> outputTest) {
        return new JournalPageRecipe(() -> {
            RecipeManager mgr = RecipeHelper.getRecipeManager();
            if (mgr == null) {
                throw new IllegalStateException("Not connected to a server, but calling GUI code?");
            }
            IRecipe recipe = mgr.func_215366_a(IRecipeType.field_222149_a).values().stream().filter(r -> outputTest.test(r.func_77571_b())).findFirst().orElse(null);
            if (recipe != null) {
                return recipe;
            }
            recipe = mgr.func_215366_a(RecipeTypesAS.TYPE_ALTAR.getType()).values().stream().map(r -> (SimpleAltarRecipe)r).filter(r -> outputTest.test(r.getOutputForRender(Collections.emptyList()))).findFirst().orElse(null);
            if (recipe != null) {
                return recipe;
            }
            return null;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderablePage buildRenderPage(ResearchNode node, int nodePage) {
        IRecipe<?> recipe = this.recipeProvider.get();
        if (recipe instanceof SimpleAltarRecipe) {
            return new RenderPageAltarRecipe(node, nodePage, (SimpleAltarRecipe)recipe);
        }
        if (recipe != null) {
            return RenderPageRecipe.fromRecipe(node, nodePage, recipe);
        }
        return new RenderPageText("astralsorcery.journal.recipe.removalinfo");
    }
}

