/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class ClientLightBlockEndpoints
extends ClientData<ClientLightBlockEndpoints> {
    private final Map<RegistryKey<World>, Set<BlockPos>> clientPositions = new HashMap<RegistryKey<World>, Set<BlockPos>>();

    public boolean doesPositionReceiveStarlightClient(World world, BlockPos pos) {
        return this.clientPositions.getOrDefault(world.func_234923_W_(), Collections.emptySet()).contains(pos);
    }

    @Override
    public void clear(RegistryKey<World> dim) {
        this.clientPositions.remove(dim);
    }

    @Override
    public void clearClient() {
        this.clientPositions.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientLightBlockEndpoints> {
        @Override
        public void readFromIncomingFullSync(ClientLightBlockEndpoints data, CompoundNBT compound) {
            data.clientPositions.clear();
            for (String dimKey : compound.func_150296_c()) {
                RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimKey));
                HashSet<BlockPos> positions = new HashSet<BlockPos>();
                ListNBT list = compound.func_150295_c(dimKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("pos"));
                    positions.add(pos);
                }
                data.clientPositions.put(dim, positions);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientLightBlockEndpoints data, CompoundNBT compound) {
            HashSet<String> clearedDimensions = new HashSet<String>();
            for (INBT dimKeyNBT : compound.func_150295_c("clear", 8)) {
                String dimKey = dimKeyNBT.func_150285_a_();
                RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimKey));
                data.clientPositions.remove(dim);
                clearedDimensions.add(dimKey);
            }
            for (String dimKey : compound.func_150296_c()) {
                if (clearedDimensions.contains(dimKey)) continue;
                RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimKey));
                Set positions = data.clientPositions.computeIfAbsent(dim, k -> new HashSet());
                ListNBT list = compound.func_150295_c(dimKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("pos"));
                    boolean addNew = tag.func_74767_n("add");
                    if (addNew) {
                        positions.add(pos);
                        continue;
                    }
                    positions.remove(pos);
                }
            }
        }
    }
}

