/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event;

import hellfirepvp.astralsorcery.common.util.tick.TimeoutList;
import hellfirepvp.astralsorcery.common.util.tick.TimeoutListContainer;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;

public class PlayerAffectionFlags {
    private static final int DEFAULT_TICK_TIMEOUT = 10;
    private static final TimeoutListContainer<UUID, AffectionFlag> affectMap = new TimeoutListContainer(new TimeoutListContainer.ForwardingTimeoutDelegate(), TickEvent.Type.SERVER);

    private PlayerAffectionFlags() {
    }

    public static void attachTickListeners(Consumer<ITickHandler> registrar) {
        registrar.accept(affectMap);
    }

    public static void clearServerCache() {
        affectMap.clear();
    }

    public static void markPlayerAffected(PlayerEntity player, AffectionFlag flag) {
        affectMap.getOrCreateList(player.func_110124_au()).setOrAddTimeout(10, flag);
    }

    public static boolean isPlayerAffected(PlayerEntity player, AffectionFlag flag) {
        UUID playerUUID = player.func_110124_au();
        return affectMap.hasList(playerUUID) && affectMap.getOrCreateList(playerUUID).contains(flag);
    }

    public static class NoOpAffectionFlag
    extends AffectionFlag {
        public NoOpAffectionFlag(ResourceLocation key) {
            super(key);
        }

        @Override
        public void onTimeout(UUID object) {
        }
    }

    public static abstract class AffectionFlag
    implements TimeoutList.TimeoutDelegate<UUID> {
        private final ResourceLocation key;

        public AffectionFlag(ResourceLocation key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffectionFlag that = (AffectionFlag)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

