/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.loot.global;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyMagnetDrops;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.loot.LootUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.LogicalSide;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class LootModifierMagnetDrops
extends LootModifier {
    private LootModifierMagnetDrops(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!LootUtil.doesContextFulfillSet(context, LootParameterSets.field_216267_h)) {
            return generatedLoot;
        }
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(e instanceof PlayerEntity)) {
            return generatedLoot;
        }
        PlayerEntity player = (PlayerEntity)e;
        PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (!prog.isValid() || !prog.getPerkData().hasPerkEffect(perk -> perk instanceof KeyMagnetDrops)) {
            return generatedLoot;
        }
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null && tool.func_77942_o() && tool.func_77978_p().func_74764_b("HasCuriosFortuneBonus")) {
            return generatedLoot.stream().filter(stack -> !stack.func_190926_b()).map(result -> ItemUtils.dropItemToPlayer(player, result)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        }
        int curiosFortuneBonus = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(ICuriosItemHandler::getFortuneBonus).orElse(0);
        if (curiosFortuneBonus > 0) {
            return generatedLoot;
        }
        return generatedLoot.stream().filter(stack -> !stack.func_190926_b()).map(result -> ItemUtils.dropItemToPlayer(player, result)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LootModifierMagnetDrops> {
        public LootModifierMagnetDrops read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new LootModifierMagnetDrops(lootConditions);
        }

        public JsonObject write(LootModifierMagnetDrops instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

