/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.common.capability.ChunkFluidEntry;
import hellfirepvp.astralsorcery.common.lib.CapabilitiesAS;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class RegistryCapabilities {
    private RegistryCapabilities() {
    }

    public static void init(IEventBus eventBus) {
        RegistryCapabilities.registerDefault(ChunkFluidEntry.class, ChunkFluidEntry::new);
        eventBus.addGenericListener(Chunk.class, RegistryCapabilities::attachChunkCapability);
    }

    private static void attachChunkCapability(AttachCapabilitiesEvent<Chunk> chunkEvent) {
        chunkEvent.addCapability(CapabilitiesAS.CHUNK_FLUID_KEY, RegistryCapabilities.serializeableProvider((INBTSerializable)CapabilitiesAS.CHUNK_FLUID.getDefaultInstance()));
    }

    private static <T extends INBTSerializable<CompoundNBT>> void registerDefault(Class<T> capabilityClass, Supplier<T> capProvider) {
        RegistryCapabilities.register(capabilityClass, RegistryCapabilities.serializeableStorage(), capProvider);
    }

    private static <T> void register(Class<T> capabilityClass, Capability.IStorage<T> capStorage, Supplier<T> capProvider) {
        CapabilityManager.INSTANCE.register(capabilityClass, capStorage, capProvider::get);
    }

    private static <E extends INBTSerializable<CompoundNBT>> ICapabilitySerializable<CompoundNBT> serializeableProvider(final E defaultInstance) {
        return new ICapabilitySerializable<CompoundNBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilitiesAS.CHUNK_FLUID) {
                    return LazyOptional.of(() -> defaultInstance);
                }
                return LazyOptional.empty();
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)defaultInstance.serializeNBT();
            }

            public void deserializeNBT(CompoundNBT nbt) {
                defaultInstance.deserializeNBT((INBT)nbt);
            }
        };
    }

    private static <T extends INBTSerializable<CompoundNBT>> Capability.IStorage<T> serializeableStorage() {
        return new Capability.IStorage<T>(){

            @Nullable
            public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        };
    }
}

