/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.WorldGenerationAS;
import hellfirepvp.astralsorcery.common.world.FeatureGenerationConfig;
import hellfirepvp.astralsorcery.common.world.StructureGenerationConfig;
import hellfirepvp.astralsorcery.common.world.TemplateStructureFeature;
import hellfirepvp.astralsorcery.common.world.feature.config.ReplaceBlockConfig;
import hellfirepvp.astralsorcery.common.world.structure.AncientShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.DesertShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.SmallShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureAncientShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureDesertShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureSmallShrineStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class RegistryWorldGeneration {
    private static final Map<StructureFeature<?, ?>, StructureGenerationConfig> STRUCTURES = new HashMap();
    private static final Map<ConfiguredFeature<?, ?>, FeatureGenerationConfig> FEATURES = new HashMap();
    private static final Map<ConfiguredFeature<?, ?>, GenerationStage.Decoration> FEATURE_STAGE = new HashMap();

    public static void init() {
        RegistryWorldGeneration.registerFeature(WorldGenerationAS.Features.KEY_FEATURE_REPLACE_BLOCK, WorldGenerationAS.Features.REPLACE_BLOCK);
        RegistryWorldGeneration.registerFeature(WorldGenerationAS.Features.KEY_FEATURE_ROCK_CRYSTAL, WorldGenerationAS.Features.ROCK_CRYSTAL);
        RegistryWorldGeneration.registerPlacement(WorldGenerationAS.Placements.KEY_PLACEMENT_CHANCE, WorldGenerationAS.Placements.CHANCE);
        RegistryWorldGeneration.registerPlacement(WorldGenerationAS.Placements.KEY_PLACEMENT_RIVERBED, WorldGenerationAS.Placements.RIVERBED);
        RegistryWorldGeneration.registerPlacement(WorldGenerationAS.Placements.KEY_PLACEMENT_WORLD_FILTER, WorldGenerationAS.Placements.WORLD_FILTER);
        WorldGenerationAS.Structures.ANCIENT_SHRINE_PIECE = RegistryWorldGeneration.registerStructurePiece(WorldGenerationAS.Structures.KEY_ANCIENT_SHRINE, AncientShrineStructure::new);
        WorldGenerationAS.Structures.DESERT_SHRINE_PIECE = RegistryWorldGeneration.registerStructurePiece(WorldGenerationAS.Structures.KEY_DESERT_SHRINE, DesertShrineStructure::new);
        WorldGenerationAS.Structures.SMALL_SHRINE_PIECE = RegistryWorldGeneration.registerStructurePiece(WorldGenerationAS.Structures.KEY_SMALL_SHRINE, SmallShrineStructure::new);
        WorldGenerationAS.Structures.STRUCTURE_ANCIENT_SHRINE = RegistryWorldGeneration.registerStructure(WorldGenerationAS.Structures.KEY_ANCIENT_SHRINE, WorldGenerationAS.Config.CFG_ANCIENT_SHRINE, new FeatureAncientShrineStructure());
        WorldGenerationAS.Structures.STRUCTURE_DESERT_SHRINE = RegistryWorldGeneration.registerStructure(WorldGenerationAS.Structures.KEY_DESERT_SHRINE, WorldGenerationAS.Config.CFG_DESERT_SHRINE, new FeatureDesertShrineStructure());
        WorldGenerationAS.Structures.STRUCTURE_SMALL_SHRINE = RegistryWorldGeneration.registerStructure(WorldGenerationAS.Structures.KEY_SMALL_SHRINE, WorldGenerationAS.Config.CFG_SMALL_SHRINE, new FeatureSmallShrineStructure());
        WorldGenerationAS.Features.GEN_GLOW_FLOWER = RegistryWorldGeneration.registerConfiguredFeature(WorldGenerationAS.Features.KEY_GLOW_FLOWER, GenerationStage.Decoration.VEGETAL_DECORATION, WorldGenerationAS.Config.CFG_GLOW_FLOWER, ((ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlocksAS.GLOW_FLOWER.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(12).func_227322_d_()).func_242732_c(6)).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(WorldGenerationAS.Placements.WORLD_FILTER.func_227446_a_(WorldGenerationAS.Config.CFG_GLOW_FLOWER.worldFilterConfig())));
        WorldGenerationAS.Features.GEN_ROCK_CRYSTAL = RegistryWorldGeneration.registerConfiguredFeature(WorldGenerationAS.Features.KEY_ROCK_CRYSTAL, GenerationStage.Decoration.UNDERGROUND_ORES, WorldGenerationAS.Config.CFG_ROCK_CRYSTAL, WorldGenerationAS.Features.ROCK_CRYSTAL.func_225566_b_(new ReplaceBlockConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlocksAS.ROCK_CRYSTAL_ORE.func_176223_P())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(5, 0, 2))).func_227228_a_(WorldGenerationAS.Placements.CHANCE.withChance(0.04f)).func_227228_a_(WorldGenerationAS.Placements.WORLD_FILTER.func_227446_a_(WorldGenerationAS.Config.CFG_ROCK_CRYSTAL.worldFilterConfig())));
        WorldGenerationAS.Features.GEN_AQUAMARINE = RegistryWorldGeneration.registerConfiguredFeature(WorldGenerationAS.Features.KEY_AQUAMARINE, GenerationStage.Decoration.UNDERGROUND_ORES, WorldGenerationAS.Config.CFG_AQUAMARINE, ((ConfiguredFeature)WorldGenerationAS.Features.REPLACE_BLOCK.func_225566_b_(new ReplaceBlockConfig((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_203436_u), BlocksAS.AQUAMARINE_SAND_ORE.func_176223_P())).func_227228_a_(WorldGenerationAS.Placements.RIVERBED.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_)).func_242732_c(8)).func_227228_a_(WorldGenerationAS.Placements.WORLD_FILTER.func_227446_a_(WorldGenerationAS.Config.CFG_AQUAMARINE.worldFilterConfig())));
        WorldGenerationAS.Features.GEN_MARBLE = RegistryWorldGeneration.registerConfiguredFeature(WorldGenerationAS.Features.KEY_MARBLE, GenerationStage.Decoration.UNDERGROUND_ORES, WorldGenerationAS.Config.CFG_MARBLE, ((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlocksAS.MARBLE_RAW.func_176223_P(), 26)).func_242733_d(96)).func_242728_a()).func_242732_c(10)).func_227228_a_(WorldGenerationAS.Placements.WORLD_FILTER.func_227446_a_(WorldGenerationAS.Config.CFG_MARBLE.worldFilterConfig())));
    }

    public static void registerStructureGeneration() {
        ArrayList<Map> structureSettings = new ArrayList<Map>();
        structureSettings.add(DimensionSettings.field_242740_q.func_236108_a_().func_236195_a_());
        WorldGenRegistries.field_243658_j.forEach(settings -> structureSettings.add(settings.func_236108_a_().func_236195_a_()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)DimensionStructuresSettings.field_236191_b_);
        STRUCTURES.forEach((structureFeature, cfg) -> {
            if (cfg.isEnabled()) {
                StructureSeparationSettings settings = cfg.createSettings();
                builder.put((Object)structureFeature.field_236268_b_, (Object)settings);
                structureSettings.forEach(noiseStructureSettings -> noiseStructureSettings.put(structureFeature.field_236268_b_, settings));
            }
        });
        DimensionStructuresSettings.field_236191_b_ = builder.build();
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object[])new Structure[]{WorldGenerationAS.Structures.STRUCTURE_ANCIENT_SHRINE, WorldGenerationAS.Structures.STRUCTURE_DESERT_SHRINE, WorldGenerationAS.Structures.STRUCTURE_SMALL_SHRINE}).build();
    }

    public static void loadBiomeFeatures(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        STRUCTURES.forEach((structureFeature, cfg) -> {
            if (cfg.isEnabled() && cfg.canGenerateIn(event.getCategory())) {
                gen.func_242516_a(structureFeature);
            }
        });
        FEATURES.forEach((feature, cfg) -> {
            if (cfg.isEnabled() && cfg.canGenerateIn(event.getCategory())) {
                GenerationStage.Decoration stage = FEATURE_STAGE.get(feature);
                if (stage == null) {
                    ResourceLocation key = WorldGenRegistries.field_243653_e.func_230519_c_(feature).map(RegistryKey::func_240901_a_).orElse(new ResourceLocation("not_registered"));
                    throw new IllegalArgumentException("Unknown generation stage for feature " + key + "!");
                }
                gen.func_242513_a(stage, feature);
            }
        });
    }

    public static void addConfigEntries(Consumer<ConfigEntry> registrar) {
        registrar.accept(WorldGenerationAS.Config.CFG_ANCIENT_SHRINE);
        registrar.accept(WorldGenerationAS.Config.CFG_DESERT_SHRINE);
        registrar.accept(WorldGenerationAS.Config.CFG_SMALL_SHRINE);
        registrar.accept(WorldGenerationAS.Config.CFG_GLOW_FLOWER);
        registrar.accept(WorldGenerationAS.Config.CFG_ROCK_CRYSTAL);
        registrar.accept(WorldGenerationAS.Config.CFG_AQUAMARINE);
        registrar.accept(WorldGenerationAS.Config.CFG_MARBLE);
    }

    private static ConfiguredFeature<?, ?> registerConfiguredFeature(ResourceLocation key, GenerationStage.Decoration stage, FeatureGenerationConfig cfg, ConfiguredFeature<?, ?> feature) {
        FEATURE_STAGE.put(feature, stage);
        FEATURES.put(feature, cfg);
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)key, feature);
    }

    private static void registerFeature(ResourceLocation key, Feature<?> feature) {
        AstralSorcery.getProxy().getRegistryPrimer().register(feature.setRegistryName(key));
    }

    private static void registerPlacement(ResourceLocation key, Placement<?> placement) {
        AstralSorcery.getProxy().getRegistryPrimer().register(placement.setRegistryName(key));
    }

    private static <T extends IStructurePieceType> T registerStructurePiece(ResourceLocation key, T type) {
        return (T)((IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)key, type));
    }

    private static <S extends TemplateStructureFeature> S registerStructure(ResourceLocation key, StructureGenerationConfig cfg, S structure) {
        AstralSorcery.getProxy().getRegistryPrimer().register(structure.setRegistryName(key));
        Structure.field_236365_a_.put((Object)structure.func_143025_a(), structure);
        StructureFeature structureFeature = structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        STRUCTURES.put(structureFeature, cfg);
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)key, (Object)structureFeature);
        return structure;
    }
}

