/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.tile.base.TileNetwork;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class TransmissionNetworkHelper {
    private static final double MAX_TRANSMISSION_DIST = 16.0;

    public static boolean hasTransmissionLink(IStarlightTransmission<?> tr, BlockPos end) {
        Object node = tr.getNode();
        if (node == null) {
            return false;
        }
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(tr.getTrWorld());
        List<NodeConnection<IPrismTransmissionNode>> nextNodes = node.queryNext(handler);
        for (NodeConnection<IPrismTransmissionNode> nextNode : nextNodes) {
            if (!nextNode.getTo().equals((Object)end)) continue;
            return true;
        }
        return false;
    }

    public static boolean canCreateTransmissionLink(IStarlightTransmission<?> tr, BlockPos end) {
        Object node = tr.getNode();
        if (node == null) {
            return false;
        }
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(tr.getTrWorld());
        List<NodeConnection<IPrismTransmissionNode>> nextNodes = node.queryNext(handler);
        for (NodeConnection<IPrismTransmissionNode> nextNode : nextNodes) {
            if (!nextNode.getTo().equals((Object)end)) continue;
            return false;
        }
        return tr.getTrPos().func_218141_a((Vector3i)new BlockPos((Vector3i)end), 16.0);
    }

    public static boolean createTransmissionLink(IStarlightTransmission<?> tr, BlockPos next) {
        Object node = tr.getNode();
        if (node == null) {
            AstralSorcery.log.info("Trying to create transmission link on non-existing transmission tile! Not creating link!");
            return false;
        }
        TransmissionNetworkHelper.createLink(node, tr, next);
        return true;
    }

    public static void removeTransmissionLink(IStarlightTransmission<?> tr, BlockPos next) {
        Object node = tr.getNode();
        if (node == null) {
            return;
        }
        TransmissionNetworkHelper.removeLink(node, tr, next);
    }

    private static void removeLink(IPrismTransmissionNode transmissionNode, IStarlightTransmission<?> transmission, BlockPos to) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(transmission.getTrWorld());
        IPrismTransmissionNode nextNode = handler.getTransmissionNode(to);
        TransmissionNetworkHelper.removeLink(transmissionNode, nextNode, transmission.getTrWorld(), transmission.getTrPos(), to);
        handler.markDirty(new Vector3i[]{transmission.getTrPos(), to});
    }

    private static void removeLink(IPrismTransmissionNode thisNode, IPrismTransmissionNode nextNode, World world, BlockPos from, BlockPos to) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        if (nextNode != null) {
            nextNode.notifySourceUnlink(world, from);
            if (handle != null) {
                handle.notifyTransmissionNodeChange(nextNode);
            }
        }
        thisNode.notifyUnlink(world, to);
        if (handle != null) {
            handle.notifyTransmissionNodeChange(thisNode);
        }
    }

    private static void createLink(IPrismTransmissionNode transmissionNode, IStarlightTransmission<?> transmission, BlockPos to) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(transmission.getTrWorld());
        IPrismTransmissionNode nextNode = handler.getTransmissionNode(to);
        TransmissionNetworkHelper.createLink(transmissionNode, nextNode, transmission.getTrWorld(), transmission.getTrPos(), to);
        handler.markDirty(new Vector3i[]{transmission.getTrPos(), to});
    }

    private static void createLink(IPrismTransmissionNode thisNode, IPrismTransmissionNode nextNode, World world, BlockPos from, BlockPos to) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        if (nextNode != null) {
            nextNode.notifySourceLink(world, from);
            if (handle != null) {
                handle.notifyTransmissionNodeChange(nextNode);
            }
        }
        thisNode.notifyLink(world, to);
        if (handle != null) {
            handle.notifyTransmissionNodeChange(thisNode);
        }
    }

    public static boolean isTileInNetwork(TileNetwork<?> tileNetwork) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(tileNetwork.func_145831_w());
        return handler.getTransmissionNode(tileNetwork.func_174877_v()) != null;
    }

    public static void informNetworkTilePlacement(TileNetwork<?> tileNetwork) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(tileNetwork.func_145831_w());
        if (tileNetwork instanceof IStarlightSource) {
            handler.addNewSourceTile((IStarlightSource)((Object)tileNetwork));
        } else if (tileNetwork instanceof IStarlightTransmission) {
            handler.addTransmissionTile((IStarlightTransmission)((Object)tileNetwork));
        } else {
            AstralSorcery.log.warn("Placed a network tile that's not transmission/receiver or source! At: dim=" + tileNetwork.func_145831_w().func_234923_W_().func_240901_a_() + ", pos=" + tileNetwork.func_174877_v());
        }
        IPrismTransmissionNode node = handler.getTransmissionNode(tileNetwork.func_174877_v());
        if (node == null) {
            AstralSorcery.log.warn("Placed a network tile that didn't produce a network node! At: dim=" + tileNetwork.func_145831_w().func_234923_W_().func_240901_a_() + ", pos=" + tileNetwork.func_174877_v());
        } else if (node.needsUpdate()) {
            StarlightUpdateHandler.getInstance().addNode(tileNetwork.func_145831_w(), node);
        }
    }

    public static void informNetworkTileRemoval(TileNetwork<?> tileNetwork) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(tileNetwork.func_145831_w());
        IPrismTransmissionNode node = handler.getTransmissionNode(tileNetwork.func_174877_v());
        if (node == null) {
            AstralSorcery.log.warn("Tried to get a network node at a TileEntity, but didn't find one! At: dim=" + tileNetwork.func_145831_w().func_234923_W_().func_240901_a_() + ", pos=" + tileNetwork.func_174877_v());
        } else {
            StarlightUpdateHandler.getInstance().removeNode(((IStarlightTransmission)((Object)tileNetwork)).getTrWorld(), node);
        }
        if (tileNetwork instanceof IStarlightSource) {
            handler.removeSource((IStarlightSource)((Object)tileNetwork));
        } else if (tileNetwork instanceof IStarlightTransmission) {
            handler.removeTransmission((IStarlightTransmission)((Object)tileNetwork));
        } else {
            AstralSorcery.log.warn("Removed a network tile that's not transmission/receiver or source! At: dim=" + tileNetwork.func_145831_w().func_234923_W_().func_240901_a_() + ", pos=" + tileNetwork.func_174877_v());
        }
    }
}

