/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.altar;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.nbt.CompoundNBT;

public class DeferredStarlightStorage {
    private final Deque<Integer> starlightStorage = new LinkedList<Integer>();
    private final int ticksDeferred;

    public DeferredStarlightStorage(int ticksDeferred) {
        Preconditions.checkArgument((ticksDeferred > 0 ? 1 : 0) != 0, (Object)"DeferredStarlightStorage must be set to defer by at least 1 tick.");
        this.ticksDeferred = ticksDeferred;
    }

    public void setStoredStarlight(int starlight) {
        while (this.starlightStorage.size() >= this.ticksDeferred) {
            this.starlightStorage.removeLast();
        }
        this.starlightStorage.addFirst(starlight);
    }

    public int getStoredStarlight() {
        if (this.starlightStorage.isEmpty()) {
            return 0;
        }
        return this.starlightStorage.getLast();
    }

    public void readNBT(CompoundNBT compound) {
        this.starlightStorage.clear();
        this.starlightStorage.addLast(compound.func_74762_e("starlightStorage"));
    }

    public void writeNBT(CompoundNBT compound) {
        compound.func_74768_a("starlightStorage", this.getStoredStarlight());
    }
}

