/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import java.util.Random;

public class PartialEffectExecutor {
    private static final Random random = new Random();
    private final Random rand;
    private final float amount;
    private float currentAmount;

    public PartialEffectExecutor(float amount) {
        this(amount, random);
    }

    public PartialEffectExecutor(float amount, Random rand) {
        this.rand = rand;
        this.amount = amount;
        this.currentAmount = amount;
    }

    public boolean canExecute() {
        return this.currentAmount > 1.0f || this.rand.nextFloat() < this.currentAmount;
    }

    public void markExecution() {
        this.currentAmount -= 1.0f;
    }

    public void reset() {
        this.currentAmount = this.amount;
    }

    public boolean executeAll(Runnable run) {
        boolean ranAtLeastOnce = false;
        while (this.canExecute()) {
            this.markExecution();
            run.run();
            ranAtLeastOnce = true;
        }
        return ranAtLeastOnce;
    }
}

