/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.object.TransformReference;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class WorldBlockPos
extends BlockPos {
    private final TransformReference<RegistryKey<World>, World> worldReference;

    private WorldBlockPos(TransformReference<RegistryKey<World>, World> worldReference, BlockPos pos) {
        super((Vector3i)pos);
        this.worldReference = worldReference;
    }

    private WorldBlockPos(RegistryKey<World> type, BlockPos pos, Function<RegistryKey<World>, World> worldProvider) {
        super((Vector3i)pos);
        this.worldReference = new TransformReference<RegistryKey<World>, World>(type, worldProvider);
    }

    public static WorldBlockPos wrapServer(World world, BlockPos pos) {
        return new WorldBlockPos((RegistryKey<World>)world.func_234923_W_(), pos, type -> {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            return server.func_71218_a(type);
        });
    }

    public static WorldBlockPos wrapTileEntity(TileEntity tile) {
        return new WorldBlockPos((RegistryKey<World>)tile.func_145831_w().func_234923_W_(), tile.func_174877_v(), type -> tile.func_145831_w());
    }

    public RegistryKey<World> getWorldKey() {
        return this.worldReference.getReference();
    }

    private WorldBlockPos wrapInternal(BlockPos pos) {
        return new WorldBlockPos(this.worldReference, pos);
    }

    public WorldBlockPos add(int x, int y, int z) {
        return this.wrapInternal(super.func_177982_a(x, y, z));
    }

    public WorldBlockPos add(double x, double y, double z) {
        return this.wrapInternal(super.func_177963_a(x, y, z));
    }

    public WorldBlockPos add(Vector3i vec) {
        return this.wrapInternal(super.func_177971_a(vec));
    }

    @Nullable
    public <T extends TileEntity> T getTileAt(Class<T> tileClass, boolean forceChunkLoad) {
        World world = this.worldReference.getValue();
        if (world != null) {
            return (T)((TileEntity)MiscUtils.getTileAt((IBlockReader)world, this, tileClass, forceChunkLoad));
        }
        return null;
    }

    @Nullable
    public World getWorld() {
        return this.worldReference.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorldBlockPos that = (WorldBlockPos)((Object)o);
        return Objects.equals(this.getWorldKey(), that.getWorldKey());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getWorldKey().hashCode();
        return result;
    }
}

