/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.world.FeatureGenerationConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.ForgeConfigSpec;

public class StructureGenerationConfig
extends FeatureGenerationConfig {
    private final int defaultSpacing;
    private final int defaultSeparation;
    private ForgeConfigSpec.IntValue spacing;
    private ForgeConfigSpec.IntValue separation;

    public StructureGenerationConfig(ResourceLocation featureName, int spacing, int separation) {
        this(featureName.func_110623_a(), spacing, separation);
    }

    public StructureGenerationConfig(String featureName, int spacing, int separation) {
        super(featureName);
        this.defaultSpacing = spacing;
        this.defaultSeparation = separation;
    }

    @Override
    public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
        super.createEntries(cfgBuilder);
        this.spacing = cfgBuilder.comment("Defines the structure spacing for worldgen").translation(this.translationKey("spacing")).defineInRange("spacing", this.defaultSpacing, 1, 512);
        this.separation = cfgBuilder.comment("Defines the structure separation for worldgen").translation(this.translationKey("separation")).defineInRange("separation", this.defaultSeparation, 1, 512);
    }

    public StructureSeparationSettings createSettings() {
        return new StructureSeparationSettings(((Integer)this.spacing.get()).intValue(), ((Integer)this.separation.get()).intValue(), Math.abs(this.getFullPath().hashCode()));
    }
}

