/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerEnergy
implements IIngredientComponentTerminalStorageHandler<Long, Boolean> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerEnergy(IngredientComponent<Long, Boolean> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)RegistryEntries.ITEM_ENERGY_BATTERY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(MatrixStack matrixStack, Long instance, long maxQuantity, @Nullable String label, ContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<ITextComponent> additionalTooltipLines) {
        if (instance > 0L) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                int progressMaxScaled;
                int progressScaled;
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.func_227780_a_();
                RenderHelpers.bindTexture((ResourceLocation)Images.ICONS);
                gui.func_238474_b_(matrixStack, x, y, 0, 240, GuiHelpers.SLOT_SIZE_INNER, GuiHelpers.SLOT_SIZE_INNER);
                if ((long)((int)maxQuantity) == maxQuantity) {
                    progressScaled = (int)instance.longValue();
                    progressMaxScaled = (int)maxQuantity;
                } else {
                    progressScaled = (int)(instance >> 16);
                    progressMaxScaled = (int)(maxQuantity >> 16);
                }
                GuiHelpers.renderProgressBar((AbstractGui)gui, (MatrixStack)matrixStack, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)16, (int)240, (GuiHelpers.ProgressDirection)GuiHelpers.ProgressDirection.UP, (int)progressScaled, (int)progressMaxScaled);
                GlStateManager.func_227722_g_();
                RenderItemExtendedSlotCount.getInstance().drawSlotText(Minecraft.func_71410_x().field_71466_p, new MatrixStack(), label != null ? label : GuiHelpers.quantityToScaledString((long)instance), x, y);
                RenderHelper.func_74518_a();
            } else {
                GuiHelpers.renderTooltip((ContainerScreen)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(new TranslationTextComponent("gui.integratedterminals.terminal_storage.tooltip.energy"));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(Long instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.energy.amount", (Object[])new Object[]{String.format("%,d", instance)});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @Override
    public Long getInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).longValue();
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<Long, Boolean> storage, Long maxInstance, PlayerEntity player) {
        return 0;
    }

    protected IIngredientComponentStorage<Long, Boolean> getEnergyStorage(IngredientComponent<Long, Boolean> component, IEnergyStorage energyStorage) {
        return component.getStorageWrapperHandler(CapabilityEnergy.ENERGY).wrapComponentStorage((Object)energyStorage);
    }

    @Override
    public Long insertIntoContainer(IIngredientComponentStorage<Long, Boolean> storage, Container container, int containerSlot, Long maxInstance, @Nullable PlayerEntity player, boolean transferFullSelection) {
        ItemStack stack = container.func_75139_a(containerSlot).func_75211_c();
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            Long ret = 0L;
            try {
                ret = (Long)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (long)maxInstance, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75142_b();
            return ret;
        }).orElse(0L);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<Long, Boolean> storage, PlayerInventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = playerInventory.func_70445_o();
        playerStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<Long, Boolean> storage, Container container, int containerSlot, PlayerInventory playerInventory, int limit) {
        ItemStack toMoveStack = container.func_75139_a(containerSlot).func_75211_c();
        toMoveStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    public long getActivePlayerStackQuantity(PlayerInventory playerInventory) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        return toMoveStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(PlayerInventory playerInventory, long quantityIn) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        toMoveStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = energyStorage.extractEnergy((int)quantity, false)) > 0; quantity -= (long)drained) {
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<Long> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return integer -> true;
    }

    @Override
    public Collection<IIngredientInstanceSorter<Long>> getInstanceSorters() {
        return Collections.emptyList();
    }
}

