/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackQuantitySorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;
import org.lwjgl.opengl.GL11;

public class IngredientComponentTerminalStorageHandlerItemStack
implements IIngredientComponentTerminalStorageHandler<ItemStack, Integer> {
    private final IngredientComponent<ItemStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerItemStack(IngredientComponent<ItemStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)Blocks.field_150486_ae);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(MatrixStack matrixStack, ItemStack instance, long maxQuantity, @Nullable String label, ContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<ITextComponent> additionalTooltipLines) {
        RenderItemExtendedSlotCount renderItem = RenderItemExtendedSlotCount.getInstance();
        GlStateManager.func_227626_N_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        RenderHelper.func_227780_a_();
        GlStateManager.func_227623_K_();
        GlStateManager.func_227734_k_();
        GL11.glEnable((int)2929);
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(instance, x, y);
            renderItem.func_180453_a(Minecraft.func_71410_x().field_71466_p, instance, x, y, label);
        } else {
            GuiUtils.preItemToolTip((ItemStack)instance);
            GuiHelpers.renderTooltip((ContainerScreen)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                List lines = instance.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                if (additionalTooltipLines != null) {
                    lines.addAll(additionalTooltipLines);
                }
                this.addQuantityTooltip(lines, instance);
                return lines;
            });
            GuiUtils.postItemToolTip();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_227627_O_();
    }

    @Override
    public String formatQuantity(ItemStack instance) {
        return String.format("%,d", instance.func_190916_E());
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack != null;
    }

    @Override
    public ItemStack getInstance(ItemStack itemStack) {
        return itemStack;
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.func_77976_d();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<ItemStack, Integer> storage, ItemStack maxInstance, PlayerEntity player) {
        ItemStack extracted = (ItemStack)storage.extract((Object)maxInstance, (Object)13, false);
        if (!extracted.func_190926_b()) {
            player.func_71019_a(extracted, true);
        }
        return extracted.func_190916_E();
    }

    @Override
    public ItemStack insertIntoContainer(IIngredientComponentStorage<ItemStack, Integer> storage, Container container, int containerSlotIndex, ItemStack maxInstance, @Nullable PlayerEntity player, boolean transferFullSelection) {
        int newCount;
        int inserted;
        ItemStack playerStack;
        ItemStack extracted;
        long movedTotal;
        ItemStack moved;
        ItemStack containerStack;
        IIngredientMatcher matcher = IngredientComponent.ITEMSTACK.getMatcher();
        if (maxInstance.func_190916_E() > 64) {
            maxInstance.func_190920_e(64);
        }
        Slot containerSlot = container.func_75139_a(containerSlotIndex);
        if (transferFullSelection && player != null && player.field_71071_by.func_70445_o().func_190926_b() && !(containerStack = containerSlot.func_75211_c()).func_190926_b() && !matcher.matches((Object)containerStack, (Object)maxInstance, matcher.getExactMatchNoQuantityCondition()) && containerSlot.func_82869_a(player)) {
            player.field_71071_by.func_70437_b(containerSlot.func_190901_a(player, containerStack));
            containerSlot.func_75215_d(ItemStack.field_190927_a);
        }
        long requiredQuantity = matcher.getQuantity((Object)maxInstance);
        for (movedTotal = 0L; movedTotal < requiredQuantity && !(extracted = (ItemStack)storage.extract((Object)maxInstance, matcher.getExactMatchNoQuantityCondition(), true)).func_190926_b() && ((playerStack = containerSlot.func_75211_c()).func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)extracted, (ItemStack)playerStack)) && containerSlot.func_75214_a(extracted) && !(moved = (ItemStack)storage.extract(matcher.withQuantity((Object)maxInstance, (long)(inserted = (newCount = Math.min(playerStack.func_190916_E() + extracted.func_190916_E(), extracted.func_77976_d())) - playerStack.func_190916_E())), matcher.getExactMatchNoQuantityCondition(), false)).func_190926_b(); movedTotal += (long)moved.func_190916_E()) {
            containerSlot.func_75215_d(((ItemStack)matcher.withQuantity((Object)maxInstance, (long)(containerSlot.func_75211_c().func_190916_E() + moved.func_190916_E()))).func_77946_l());
            container.func_75142_b();
        }
        return (ItemStack)matcher.withQuantity((Object)maxInstance, movedTotal);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<ItemStack, Integer> storage, PlayerInventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = (ItemStack)IngredientComponent.ITEMSTACK.getMatcher().withQuantity((Object)playerInventory.func_70445_o(), moveQuantityPlayerSlot);
        int remaining = ((ItemStack)storage.insert((Object)playerStack.func_77946_l(), false)).func_190916_E();
        int moved = (int)(moveQuantityPlayerSlot - (long)remaining);
        playerInventory.func_70445_o().func_190918_g(moved);
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<ItemStack, Integer> storage, Container container, int containerSlot, PlayerInventory playerInventory, int limit) {
        Slot slot = container.func_75139_a(containerSlot);
        ItemStack toMove = slot.func_75209_a(limit == -1 ? Integer.MAX_VALUE : limit);
        if (!toMove.func_190926_b()) {
            ItemStack remainingStack = (ItemStack)storage.insert((Object)toMove, false);
            if (!remainingStack.func_190926_b()) {
                if (!slot.func_75216_d()) {
                    slot.func_75215_d(remainingStack);
                } else {
                    playerInventory.func_70441_a(remainingStack);
                }
            }
            container.func_75142_b();
        }
    }

    @Override
    public long getActivePlayerStackQuantity(PlayerInventory playerInventory) {
        return playerInventory.func_70445_o().func_190916_E();
    }

    @Override
    public void drainActivePlayerStackQuantity(PlayerInventory playerInventory, long quantity) {
        playerInventory.func_70445_o().func_190918_g((int)quantity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<ItemStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        switch (searchMode) {
            case MOD: {
                return i -> Optional.ofNullable(i.func_77973_b().getCreatorModId(i)).orElse("minecraft").toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
            case TOOLTIP: {
                return i -> i.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().anyMatch(s -> s.getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*"));
            }
            case TAG: {
                return i -> ItemTags.func_199903_a().func_199913_a((Object)i.func_77973_b()).stream().filter(id -> id.toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).map(r -> ItemTags.func_199903_a().func_199910_a(r)).anyMatch(Objects::nonNull);
            }
            case DEFAULT: {
                return i -> i.func_200301_q().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
        }
        return null;
    }

    @Override
    public Collection<IIngredientInstanceSorter<ItemStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new ItemStackNameSorter(), new ItemStackIdSorter(), new ItemStackQuantitySorter()});
    }
}

