/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.client.gui;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class CraftingJobGuiData {
    private final BlockPos pos;
    private final Direction side;
    private final int channel;
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final Object craftingJob;

    public CraftingJobGuiData(BlockPos pos, Direction side, int channel, ITerminalStorageTabIngredientCraftingHandler handler, Object craftingJob) {
        this.pos = pos;
        this.side = side;
        this.channel = channel;
        this.handler = handler;
        this.craftingJob = craftingJob;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public int getChannel() {
        return this.channel;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public Object getCraftingJob() {
        return this.craftingJob;
    }

    public void writeToPacketBuffer(PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(this.pos);
        packetBuffer.writeInt(this.side.ordinal());
        packetBuffer.writeInt(this.channel);
        packetBuffer.func_180714_a(this.handler.getId().toString());
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("id", this.handler.serializeCraftingJobId(this.craftingJob));
        packetBuffer.func_150786_a(tag);
    }

    public static CraftingJobGuiData readFromPacketBuffer(PacketBuffer packetBuffer) {
        BlockPos pos = packetBuffer.func_179259_c();
        Direction side = Direction.values()[packetBuffer.readInt()];
        int channel = packetBuffer.readInt();
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(packetBuffer.func_150789_c(Short.MAX_VALUE)));
        Object craftingJob = handler.deserializeCraftingJobId(packetBuffer.func_150793_b().func_74781_a("id"));
        return new CraftingJobGuiData(pos, side, channel, handler, craftingJob);
    }
}

