/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.client.gui;

import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;

public class CraftingOptionGuiData<T, M, L> {
    private final IngredientComponent<T, M> component;
    private final String tabName;
    private final int channel;
    @Nullable
    private final HandlerWrappedTerminalCraftingOption<T> craftingOption;
    private final int amount;
    @Nullable
    private final HandlerWrappedTerminalCraftingPlan craftingPlan;
    private final ITerminalStorageLocation<L> location;
    private final L locationInstance;

    public CraftingOptionGuiData(IngredientComponent<T, M> component, String tabName, int channel, @Nullable HandlerWrappedTerminalCraftingOption<T> craftingOption, int amount, HandlerWrappedTerminalCraftingPlan craftingPlan, ITerminalStorageLocation<L> location, L locationInstance) {
        this.component = component;
        this.tabName = tabName;
        this.channel = channel;
        this.craftingOption = craftingOption;
        this.amount = amount;
        this.craftingPlan = craftingPlan;
        this.location = location;
        this.locationInstance = locationInstance;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getChannel() {
        return this.channel;
    }

    @Nullable
    public HandlerWrappedTerminalCraftingOption<T> getCraftingOption() {
        return this.craftingOption;
    }

    public int getAmount() {
        return this.amount;
    }

    @Nullable
    public HandlerWrappedTerminalCraftingPlan getCraftingPlan() {
        return this.craftingPlan;
    }

    public ITerminalStorageLocation<L> getLocation() {
        return this.location;
    }

    public L getLocationInstance() {
        return this.locationInstance;
    }

    public CraftingOptionGuiData<T, M, L> copyWithAmount(int amount) {
        return new CraftingOptionGuiData<T, M, L>(this.getComponent(), this.getTabName(), this.getChannel(), this.getCraftingOption(), amount, this.getCraftingPlan(), this.getLocation(), this.getLocationInstance());
    }

    public void writeToPacketBuffer(PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(this.component.getName().toString());
        packetBuffer.func_180714_a(this.tabName);
        packetBuffer.writeInt(this.channel);
        packetBuffer.writeInt(this.amount);
        packetBuffer.writeBoolean(this.craftingOption != null);
        if (this.craftingOption != null) {
            packetBuffer.func_150786_a(HandlerWrappedTerminalCraftingOption.serialize(this.craftingOption));
        }
        packetBuffer.writeBoolean(this.craftingPlan != null);
        if (this.craftingPlan != null) {
            packetBuffer.func_150786_a(HandlerWrappedTerminalCraftingPlan.serialize(this.craftingPlan));
        }
        packetBuffer.func_192572_a(this.location.getName());
        this.location.writeToPacketBuffer(packetBuffer, this.locationInstance);
    }

    public static CraftingOptionGuiData readFromPacketBuffer(PacketBuffer packetBuffer) {
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(packetBuffer.func_150789_c(Short.MAX_VALUE)));
        String tabName = packetBuffer.func_150789_c(Short.MAX_VALUE);
        int channel = packetBuffer.readInt();
        int amount = packetBuffer.readInt();
        HandlerWrappedTerminalCraftingOption craftingOption = null;
        if (packetBuffer.readBoolean()) {
            craftingOption = HandlerWrappedTerminalCraftingOption.deserialize(component, packetBuffer.func_150793_b());
        }
        HandlerWrappedTerminalCraftingPlan craftingPlan = null;
        if (packetBuffer.readBoolean()) {
            craftingPlan = HandlerWrappedTerminalCraftingPlan.deserialize(packetBuffer.func_150793_b());
        }
        ITerminalStorageLocation<?> location = TerminalStorageLocations.REGISTRY.getLocation(packetBuffer.func_192575_l());
        Object locationInstance = location.readFromPacketBuffer(packetBuffer);
        return new CraftingOptionGuiData(component, tabName, channel, craftingOption, amount, craftingPlan, location, locationInstance);
    }
}

