/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountItem;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanItem;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemOpenPacket;

public class TerminalStorageLocationItem
implements ITerminalStorageLocation<Pair<Hand, Integer>> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integratedterminals", "item");
    }

    @Override
    public <T, M> void openContainerFromClient(CraftingOptionGuiData<T, M, Pair<Hand, Integer>> craftingOptionGuiData) {
        Pair<Hand, Integer> slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.send(slot, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerFromServer(CraftingOptionGuiData<T, M, Pair<Hand, Integer>> craftingOptionGuiData, World world, ServerPlayerEntity player) {
        Pair<Hand, Integer> slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.openServer(world, slot, player, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerCraftingPlan(final CraftingOptionGuiData<T, M, Pair<Hand, Integer>> craftingOptionGuiData, World world, ServerPlayerEntity player) {
        final Pair<Hand, Integer> location = craftingOptionGuiData.getLocationInstance();
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerTerminalStorageCraftingPlanItem(id, playerInventory, (Integer)location.getRight(), (Hand)location.getLeft(), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == Hand.MAIN_HAND);
            craftingOptionGuiData.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    @Override
    public <T, M> void openContainerCraftingOptionAmount(final CraftingOptionGuiData<T, M, Pair<Hand, Integer>> craftingOptionGuiData, World world, ServerPlayerEntity player) {
        final Pair<Hand, Integer> location = craftingOptionGuiData.getLocationInstance();
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerTerminalStorageCraftingOptionAmountItem(id, playerInventory, (Integer)location.getRight(), (Hand)location.getLeft(), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == Hand.MAIN_HAND);
            craftingOptionGuiData.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer packetBuffer, Pair<Hand, Integer> location) {
        packetBuffer.func_180714_a(((Hand)location.getLeft()).name());
        packetBuffer.writeInt(((Integer)location.getRight()).intValue());
    }

    @Override
    public Pair<Hand, Integer> readFromPacketBuffer(PacketBuffer packetBuffer) {
        return Pair.of((Object)Hand.valueOf((String)packetBuffer.func_150789_c(Short.MAX_VALUE)), (Object)packetBuffer.readInt());
    }
}

