/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;

public class ContainerTerminalCraftingJobsPlan
extends ContainerMultipart<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    private final CraftingJobGuiData craftingJobGuiData;
    private final int craftingPlanNotifierId;
    private long lastUpdate;
    private Optional<ITerminalCraftingPlan> craftingPlan;

    public ContainerTerminalCraftingJobsPlan(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((PacketBuffer)packetBuffer), Optional.empty(), (PartTypeTerminalCraftingJob)PartHelpers.readPart((PacketBuffer)packetBuffer), CraftingJobGuiData.readFromPacketBuffer(packetBuffer));
    }

    public ContainerTerminalCraftingJobsPlan(int id, PlayerInventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalCraftingJob partType, CraftingJobGuiData craftingJobGuiData) {
        super(RegistryEntries.CONTAINER_PART_TERMINAL_CRAFTING_JOBS_PLAN, id, playerInventory, (IInventory)new Inventory(new ItemStack[0]), Optional.of(target), partContainer, (IPartType)partType);
        this.craftingJobGuiData = craftingJobGuiData;
        this.craftingPlan = Optional.empty();
        this.craftingPlanNotifierId = this.getNextValueId();
    }

    public CraftingJobGuiData getCraftingJobGuiData() {
        return this.craftingJobGuiData;
    }

    public Optional<ITerminalCraftingPlan> getCraftingPlan() {
        return this.craftingPlan;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.getWorld().func_201670_d() && this.lastUpdate < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        this.getTarget().ifPresent(target -> {
            INetwork network = NetworkHelpers.getNetworkChecked((PartPos)target.getCenter());
            this.craftingPlan = Optional.ofNullable(this.craftingJobGuiData.getHandler().getCraftingJob(network, this.craftingJobGuiData.getChannel(), this.craftingJobGuiData.getCraftingJob()));
            this.setValue(this.craftingPlanNotifierId, this.craftingPlan.map(p -> this.craftingJobGuiData.getHandler().serializeCraftingPlan(p)).orElse(new CompoundNBT()));
        });
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        if (valueId == this.craftingPlanNotifierId) {
            try {
                this.craftingPlan = Optional.of(this.craftingJobGuiData.getHandler().deserializeCraftingPlan(value));
            }
            catch (IllegalArgumentException e) {
                this.craftingPlan = Optional.empty();
            }
        }
        super.onUpdate(valueId, value);
    }
}

