/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class ContainerTerminalStorageItem
extends ContainerTerminalStorageBase<Pair<Hand, Integer>> {
    private final int itemIndex;
    private final Hand hand;

    public ContainerTerminalStorageItem(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, ItemInventoryContainer.readItemIndex((PacketBuffer)packetBuffer), ItemInventoryContainer.readHand((PacketBuffer)packetBuffer), packetBuffer.readBoolean() ? Optional.of(ContainerTerminalStorageBase.InitTabData.readFromPacketBuffer(packetBuffer)) : Optional.empty(), TerminalStorageState.readFromPacketBuffer(packetBuffer));
        this.getGuiState().setDirtyMarkListener(this::sendGuiStateToServer);
    }

    public ContainerTerminalStorageItem(int id, PlayerInventory playerInventory, int itemIndex, Hand hand, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        this(RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM, id, playerInventory, itemIndex, hand, initTabData, terminalStorageState);
    }

    public ContainerTerminalStorageItem(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, int itemIndex, Hand hand, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        super(type, id, playerInventory, initTabData, terminalStorageState, ContainerTerminalStorageItem.getNetworkFromItem(InventoryHelpers.getItemFromIndex((PlayerEntity)playerInventory.field_70458_d, (int)itemIndex, (Hand)hand)), ContainerTerminalStorageItem.getVariableInventoryFromItem(InventoryHelpers.getItemFromIndex((PlayerEntity)playerInventory.field_70458_d, (int)itemIndex, (Hand)hand)));
        this.itemIndex = itemIndex;
        this.hand = hand;
    }

    public static Optional<INetwork> getNetworkFromItem(ItemStack itemStack) {
        if (MinecraftHelpers.isClientSideThread()) {
            return Optional.empty();
        }
        int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
        if (groupId < 0) {
            return Optional.empty();
        }
        for (PartPos pos : PartTypeConnectorOmniDirectional.LOADED_GROUPS.getPositions(groupId)) {
            LazyOptional network = NetworkHelpers.getNetwork((PartPos)pos);
            if (!network.isPresent()) continue;
            return network.map(a -> a);
        }
        return Optional.empty();
    }

    public static Optional<ITerminalStorageTabCommon.IVariableInventory> getVariableInventoryFromItem(ItemStack itemStack) {
        return Optional.of(ItemTerminalStoragePortable.getVariableInventory(itemStack));
    }

    public ItemStack getItemStack(PlayerEntity player) {
        return InventoryHelpers.getItemFromIndex((PlayerEntity)player, (int)this.itemIndex, (Hand)this.hand);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        ItemStack item = this.getItemStack(this.player);
        return item != null && item.func_77973_b() == RegistryEntries.ITEM_TERMINAL_STORAGE_PORTABLE;
    }

    @Override
    public ITerminalStorageLocation<Pair<Hand, Integer>> getLocation() {
        return TerminalStorageLocations.ITEM;
    }

    @Override
    public Pair<Hand, Integer> getLocationInstance() {
        return Pair.of((Object)this.hand, (Object)this.itemIndex);
    }

    @Override
    public void onVariableContentsUpdated(INetwork network, IVariable<?> variable) {
    }
}

