/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientItemStackCraftingGridBalance
extends PacketCodec {
    @CodecField
    private String tabId;

    public TerminalStorageIngredientItemStackCraftingGridBalance() {
    }

    public TerminalStorageIngredientItemStackCraftingGridBalance(String tabId) {
        this.tabId = tabId;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        ContainerTerminalStorageBase container;
        if (player.field_71070_bA instanceof ContainerTerminalStorageBase && (container = (ContainerTerminalStorageBase)player.field_71070_bA).getTabServer(this.tabId) instanceof TerminalStorageTabIngredientComponentServer) {
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)container.getTabCommon(this.tabId);
            tabCommon.getInventoryCraftResult().func_70299_a(0, ItemStack.field_190927_a);
            TerminalStorageIngredientItemStackCraftingGridBalance.balanceGrid(tabCommon.getInventoryCrafting());
        }
    }

    public static void balanceGrid(CraftingInventory craftingGrid) {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)craftingGrid.func_70302_i_());
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack itemStack = craftingGrid.func_70301_a(slot);
            if (itemStack.func_190926_b()) continue;
            int amount = itemStack.func_190916_E();
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).func_77946_l();
                original.func_190920_e(1);
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).func_190917_f(amount);
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.func_190920_e(amount);
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).func_190916_E() / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).func_190916_E() % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).func_77946_l();
                itemStack.func_190920_e(((Integer)slot.getRight()).intValue());
                craftingGrid.func_70299_a(((Integer)slot.getKey()).intValue(), itemStack);
            }
        }
    }
}

