/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Scrollable;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import org.lwjgl.opengl.GL11;

public class Button
extends net.minecraft.client.gui.widget.button.Button
implements Scrollable {
    protected Integer customFrameColorLight = new Color(160, 160, 160).getRGB();
    protected Integer customFrameColorDark = new Color(120, 120, 120).getRGB();
    protected Integer customBgColor = new Color(100, 100, 100).getRGB();
    protected Integer customBgHoverColor = new Color(125, 135, 190).getRGB();
    protected Integer customBgHoverColor2 = new Color(100, 100, 100).getRGB();
    protected Integer labelColor;
    protected Integer hoverLabelColor;
    protected Integer disabledLabelColor;
    protected Integer disabledBgColor = Color.darkGray.getRGB();
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean drawLabelShadow = true;
    protected boolean showDisabledHoverText;
    protected boolean defaultStyle = true;
    protected int WIDTH_PAD = 12;
    protected String[] tooltip;
    protected String label;
    protected FontRenderer fontRenderer;
    protected Rectangle2D.Double bounds;
    protected ArrayList<Function<Button, Boolean>> clickListeners;
    private int tooltipSize;
    private boolean drawHovered;

    public Button(String label) {
        this(0, 0, label, Button.emptyPressable());
        this.resetLabelColors();
    }

    public Button(String label, Button.IPressable onPress) {
        this(0, 0, label, onPress);
        this.resetLabelColors();
    }

    public Button(int width, int height, String label, Button.IPressable onPress) {
        super(0, 0, width, height, (ITextComponent)Constants.getStringTextComponent(label), onPress);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.clickListeners = new ArrayList(0);
        this.tooltipSize = 200;
        this.drawHovered = true;
        this.label = label;
        this.finishInit();
    }

    public static Button.IPressable emptyPressable() {
        return button -> {};
    }

    public void resetLabelColors() {
        this.labelColor = new Color(0xE0E0E0).getRGB();
        this.hoverLabelColor = new Color(0xFFFFA0).getRGB();
        this.disabledLabelColor = Color.lightGray.getRGB();
    }

    protected void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.field_230689_k_ == 0) {
            this.setHeight(20);
        }
        if (this.field_230688_j_ == 0) {
            this.func_230991_b_(200);
        }
        this.updateBounds();
    }

    protected void updateLabel() {
    }

    public boolean isActive() {
        return this.isEnabled();
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.func_230458_i_().getString());
        return max + this.WIDTH_PAD + (fr.func_78260_a() ? (int)Math.ceil((double)max * 0.25) : 0);
    }

    public String getLabel() {
        return this.label;
    }

    public void fitWidth(FontRenderer fr) {
        this.func_230991_b_(this.getFitWidth(fr));
    }

    @Override
    public void drawPartialScrollable(MatrixStack mStack, Minecraft minecraft, int x, int y, int width, int height) {
        minecraft.func_110434_K().func_110577_a(field_230687_i_);
        int k = 0;
        this.func_238474_b_(mStack, x, y, 0, 46 + k * 20, width / 2, height);
        this.func_238474_b_(mStack, x + width / 2, y, 200 - width / 2, 46 + k * 20, width / 2, height);
    }

    public void showDisabledOnHover(boolean show) {
        this.showDisabledHoverText = show;
    }

    public boolean func_231047_b_(double x, double y) {
        return super.func_231047_b_((double)this.field_230690_l_, (double)this.field_230691_m_);
    }

    public boolean isMouseOver() {
        return super.func_231047_b_((double)this.field_230690_l_, (double)this.field_230691_m_);
    }

    public void setMouseOver(boolean hover) {
        this.setHovered(hover);
    }

    public void func_230988_a_(SoundHandler soundHandler) {
        if (this.isEnabled()) {
            super.func_230988_a_(soundHandler);
        }
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        if (this.defaultStyle) {
            super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        } else {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(field_230687_i_);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.setHovered(mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_);
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(mStack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, 1.0, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(mStack, this.field_230690_l_, this.field_230691_m_, 1.0, this.field_230689_k_, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(mStack, this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 1, this.field_230688_j_ - 1, 1.0, this.customFrameColorDark, 1.0f);
                DrawUtil.drawRectangle(mStack, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + 1, 1.0, this.field_230689_k_ - 1, this.customFrameColorDark, 1.0f);
            }
            if (this.isDrawBackground()) {
                DrawUtil.drawRectangle(mStack, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230688_j_ - 2, this.field_230689_k_ - 2, this.field_230692_n_ && this.drawHovered ? this.customBgHoverColor : this.customBgColor, 1.0f);
            } else if (this.isEnabled() && this.func_230449_g_() && this.drawHovered) {
                DrawUtil.drawRectangle(mStack, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230688_j_ - 2, this.field_230689_k_ - 2, this.customBgHoverColor2, 0.5f);
            }
            this.func_230441_a_(mStack, minecraft, mouseX, mouseY);
            Integer varLabelColor = this.labelColor;
            if (!this.isEnabled()) {
                varLabelColor = this.disabledLabelColor;
                if (this.drawBackground) {
                    float alpha = 0.7f;
                    int widthOffset = this.field_230688_j_ - (this.field_230689_k_ >= 20 ? 3 : 2);
                    DrawUtil.drawRectangle(mStack, this.getX() + 1, this.getY() + 1, widthOffset, this.field_230689_k_ - 2, this.disabledBgColor, alpha);
                }
            } else if (this.func_230449_g_() && this.drawHovered) {
                varLabelColor = this.hoverLabelColor;
            } else if (this.labelColor != null) {
                varLabelColor = this.labelColor;
            } else if (this.packedFGColor != 0) {
                varLabelColor = this.packedFGColor;
            }
            DrawUtil.drawCenteredLabel(mStack, this.func_230458_i_().getString(), (double)this.getCenterX(), (double)this.getMiddleY(), null, 0.0f, varLabelColor, 1.0f, 1.0, this.drawLabelShadow);
        }
    }

    public void drawHovered(boolean drawHovered) {
        this.drawHovered = drawHovered;
    }

    public void drawCenteredString(MatrixStack mStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238405_a_(mStack, text, x - (float)(fontRenderer.func_78256_a(text) / 2), y, color);
    }

    public void drawUnderline(MatrixStack mStack) {
        if (this.isVisible()) {
            DrawUtil.drawRectangle(mStack, this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_, this.field_230688_j_, 1.0, this.customFrameColorDark, 1.0f);
        }
    }

    public void secondaryDrawButton() {
    }

    public void func_230930_b_() {
        if (this.clickListeners == null || this.clickListeners.size() == 0) {
            super.func_230930_b_();
        } else {
            this.checkClickListeners();
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean mousePressed(double mouseX, double mouseY, boolean checkClickListeners) {
        boolean clicked = this.isEnabled() && this.isVisible() && this.mouseOver(mouseX, mouseY);
        return clicked && (!checkClickListeners || this.checkClickListeners());
    }

    public boolean checkClickListeners() {
        boolean clicked = true;
        if (!this.clickListeners.isEmpty()) {
            try {
                for (Function<Button, Boolean> listener : this.clickListeners) {
                    if (!listener.apply(this).booleanValue()) break;
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error trying to toggle button '" + this.func_230458_i_() + "': " + LogFormatter.toString(t));
                clicked = false;
            }
        }
        return clicked;
    }

    public String getUnformattedTooltip() {
        if (this.tooltip != null && this.tooltip.length > 0) {
            return this.tooltip[0];
        }
        return null;
    }

    public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public List<IReorderingProcessor> getTooltip() {
        ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
        if (this.tooltip != null) {
            for (String line : this.tooltip) {
                list.addAll(this.fontRenderer.func_238425_b_((ITextProperties)Constants.getStringTextComponent(line), this.tooltipSize));
            }
            return list;
        }
        if (!this.isEnabled() && this.showDisabledHoverText) {
            list.add(IReorderingProcessor.func_242239_a((String)Constants.getString("jm.common.disabled_feature"), (Style)Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))));
        }
        return list;
    }

    public void setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltip(int size, String ... tooltip) {
        this.tooltipSize = size;
        this.tooltip = tooltip;
    }

    public boolean mouseOver(double mouseX, double mouseY) {
        return this.isVisible() && this.getBounds().contains(mouseX, mouseY);
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.func_230998_h_(), this.func_238483_d_());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    @Override
    public int getScrollableWidth() {
        return this.field_230688_j_;
    }

    public void func_230991_b_(int width) {
        if (this.field_230688_j_ != width) {
            this.field_230688_j_ = width;
            this.bounds = null;
        }
    }

    @Override
    public void setScrollableWidth(int width) {
        this.func_230991_b_(width);
    }

    @Override
    public int getButtonHeight() {
        return this.func_238483_d_();
    }

    public void setHeight(int height) {
        if (this.field_230689_k_ != height) {
            this.field_230689_k_ = height;
            this.bounds = null;
            if (height != 20) {
                this.defaultStyle = false;
            }
        }
    }

    public void setTextOnly(FontRenderer fr) {
        fr.getClass();
        this.setHeight(9 + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    @Override
    public void drawScrollable(MatrixStack mStack, Minecraft mc, int mouseX, int mouseY) {
        this.func_230430_a_(mStack, mouseX, mouseY, 0.0f);
    }

    @Override
    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public int getX() {
        return this.field_230690_l_;
    }

    public void setX(int x) {
        if (this.field_230690_l_ != x) {
            this.field_230690_l_ = x;
            this.bounds = null;
        }
    }

    @Override
    public int getY() {
        return this.field_230691_m_;
    }

    public void setY(int y) {
        if (this.field_230691_m_ != y) {
            this.field_230691_m_ = y;
            this.bounds = null;
        }
    }

    public int getCenterX() {
        return this.field_230690_l_ + this.field_230688_j_ / 2;
    }

    public int getMiddleY() {
        return this.field_230691_m_ + this.field_230689_k_ / 2;
    }

    public int getBottomY() {
        return this.field_230691_m_ + this.field_230689_k_;
    }

    public int getRightX() {
        return this.field_230690_l_ + this.field_230688_j_;
    }

    @Override
    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Button leftOf(int x) {
        this.setX(x - this.func_230998_h_());
        return this;
    }

    public Button rightOf(int x) {
        this.setX(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.setX(x - this.field_230688_j_ / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.setY(y - this.field_230689_k_ / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.setX(other.getX() - this.func_230998_h_() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.setX(other.getX() + other.func_230998_h_() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.setY(other.getY() - this.func_238483_d_() - margin);
        return this;
    }

    public Button above(int y) {
        this.setY(y - this.func_238483_d_());
        return this;
    }

    public Button below(Button other, int margin) {
        this.setY(other.getY() + other.func_238483_d_() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.setY(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.setY(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.getX();
        int y = this.getY();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.getX() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.getY() - vgap - this.func_238483_d_();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.func_238483_d_() / 2;
            }
        }
        this.setX(x);
        this.setY(y);
        return this;
    }

    public boolean isEnabled() {
        return this.field_230693_o_;
    }

    public void setEnabled(boolean enabled) {
        this.field_230693_o_ = enabled;
    }

    public boolean isVisible() {
        return this.field_230694_p_;
    }

    public void setVisible(boolean visible) {
        this.field_230694_p_ = visible;
    }

    public void setDrawButton(boolean drawButton) {
        if (drawButton != this.field_230694_p_) {
            this.field_230694_p_ = drawButton;
        }
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public void setBackgroundColors(Integer customBgColor, Integer customBgHoverColor, Integer customBgHoverColor2) {
        this.customBgColor = customBgColor;
        this.customBgHoverColor = customBgHoverColor;
        this.customBgHoverColor2 = customBgHoverColor2;
    }

    public void setDrawLabelShadow(boolean draw) {
        this.drawLabelShadow = draw;
    }

    public void setLabelColors(Integer labelColor, Integer hoverLabelColor, Integer disabledLabelColor) {
        this.labelColor = labelColor;
        this.packedFGColor = labelColor;
        if (hoverLabelColor != null) {
            this.hoverLabelColor = hoverLabelColor;
        }
        if (disabledLabelColor != null) {
            this.disabledLabelColor = disabledLabelColor;
        }
    }

    public String getDisplayString() {
        return this.func_230458_i_().getString();
    }

    public void refresh() {
    }

    public Integer getLabelColor() {
        return this.labelColor;
    }

    public boolean func_230449_g_() {
        return super.func_230449_g_();
    }

    public void setHovered(boolean hovered) {
        this.field_230692_n_ = hovered;
    }

    public void addClickListener(Function<Button, Boolean> listener) {
        this.clickListeners.add(listener);
    }

    public String toString() {
        return new StringJoiner(", ", Button.class.getSimpleName() + "[", "]").add("label='" + this.label + "'").toString();
    }
}

