/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Scrollable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class ScrollPane
extends ExtendedList<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Scrollable field_230682_s_ = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    private boolean drawPartialScrollable = true;

    public ScrollPane(JmUI parent, Minecraft mc, int width, int height, List<? extends Scrollable> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, height, itemHeight + itemGap);
        for (Scrollable scrollable : items) {
            super.func_230513_b_((AbstractList.AbstractListEntry)new ScrollPaneEntry(this, scrollable));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.field_230671_e_;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.func_230940_a_(width, height, marginTop, height - marginBottom);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int func_230965_k_() {
        return super.func_230965_k_();
    }

    protected ScrollPaneEntry getEntry(int index) {
        return (ScrollPaneEntry)super.func_230953_d_(index);
    }

    public boolean func_230957_f_(int i) {
        return super.func_230957_f_(i);
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ScrollPaneEntry entry : super.func_231039_at__()) {
                Scrollable item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item instanceof Button) {
                    Button button = (Button)item;
                    if (!button.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
                    button.func_230930_b_();
                    return button;
                }
                item.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public void func_230430_a_(MatrixStack mStack, int mX, int mY, float partialTicks) {
        try {
            super.func_244605_b(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.getX(), (float)this.getY(), (float)0.0f);
        this._mouseX = mX;
        this._mouseY = mY;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.func_230430_a_(mStack, mX - this.getX(), mY - this.getY(), partialTicks);
        GL11.glPopMatrix();
    }

    protected void func_230433_a_(MatrixStack mStack) {
        boolean scrollVisible;
        int width = this.getWidth();
        float alpha = 0.4f;
        DrawUtil.drawRectangle(mStack, 0.0, this.field_230672_i_, width, this.paneHeight, Color.BLACK.getRGB(), alpha);
        boolean bl = scrollVisible = 0 < this.func_230955_e_();
        if (scrollVisible) {
            DrawUtil.drawRectangle(mStack, width - 6, this.field_230672_i_, 5.0, this.paneHeight, Color.BLACK.getRGB(), alpha);
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(mStack, -1.0, -1.0, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, -1.0, this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, -1.0, -1.0, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, width + 1, -1.0, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public void renderItem(MatrixStack mStack, int index, int y, int x, int l, int var6, int var7, float f) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.getX()), (float)(-this.getY()), (float)0.0f);
        int margin = 4;
        int itemX = this.getX() + 2;
        int itemY = y + this.getY();
        Scrollable item = ((ScrollPaneEntry)super.func_230953_d_(index)).item;
        item.setPosition(itemX, itemY);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(mStack, this.mc, this._mouseX, this._mouseY);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = itemY + item.getButtonHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (itemY < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - itemY;
            } else if (itemY < paneBottomY && itemBottomY > paneBottomY) {
                drawY = itemY;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null && this.drawPartialScrollable) {
                item.drawPartialScrollable(mStack, this.mc, itemX, drawY, item.getScrollableWidth(), item.getButtonHeight() - yDiff);
            }
        }
        GL11.glPopMatrix();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.func_231039_at__().isEmpty()) {
            return false;
        }
        if (button == 0 && this.field_230681_r_) {
            if (mouseY < (double)this.field_230672_i_) {
                this.func_230932_a_(0.0);
            } else {
                double d0 = Math.max(1, this.func_230955_e_());
                int i = this.field_230673_j_ - this.field_230672_i_;
                int j = MathHelper.func_76125_a((int)((int)((float)(i * i) / (float)this.func_230945_b_())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.func_230932_a_(this.func_230966_l_() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean inFullView(Scrollable item) {
        return item.getY() >= this.getY() && item.getY() + item.getButtonHeight() <= this.getY() + this.paneHeight;
    }

    protected int func_230952_d_() {
        return this.paneWidth;
    }

    protected void func_230947_b_(double xPos, double yPos, int button) {
        double rightX = this.getX() + this.getWidth() - 5;
        this.field_230681_r_ = button == 0 && xPos >= rightX && xPos < rightX + 10.0;
    }

    protected int func_230945_b_() {
        return super.func_230945_b_();
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.func_230955_e_();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(FontRenderer fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.func_231039_at__()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public int func_230955_e_() {
        return super.func_230955_e_();
    }

    public boolean func_231047_b_(double posX, double posY) {
        int topY = this.getY();
        int bottomY = this.getY() + this.paneHeight;
        int leftX = this.getX();
        int rightX = this.getX() + this.getWidth();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<IGuiEventListener> func_212930_a(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void func_212927_b(double mouseX, double mouseY) {
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return super.func_231042_a_(codePoint, modifiers);
    }

    public void func_212928_a(@Nullable IGuiEventListener eventListener) {
        super.func_212928_a(eventListener);
    }

    public void func_212932_b(@Nullable IGuiEventListener eventListener) {
        super.func_212932_b(eventListener);
    }

    public boolean func_231049_c__(boolean focus) {
        return super.func_231049_c__(focus);
    }

    class ScrollPaneEntry
    extends ExtendedList.AbstractListEntry<ScrollPaneEntry> {
        private ScrollPane parent;
        private Scrollable item;

        public ScrollPaneEntry(ScrollPane parent, Scrollable item) {
            this.parent = parent;
            this.item = item;
        }

        public void func_230432_a_(MatrixStack mStack, int index, int y, int x, int l, int var6, int var7, int p_230432_8_, boolean p_230432_9_, float f) {
            this.parent.renderItem(mStack, index, y, x, l, var6, var7, f);
        }
    }
}

