/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WorldIdPacket {
    public static final String CHANNEL_NAME = "world_id";
    private String worldId;

    public WorldIdPacket() {
        this.worldId = "";
    }

    public WorldIdPacket(String worldId) {
        this.worldId = worldId;
    }

    public String getWorldId() {
        return this.worldId;
    }

    public WorldIdPacket(PacketBuffer buf) {
        try {
            if (buf.capacity() > 1) {
                buf.readByte();
                this.worldId = buf.func_150789_c(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for worldId: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            if (this.worldId != null) {
                buf.writeByte(42);
                buf.func_180714_a(this.worldId);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for worldId:" + t);
        }
    }

    public static void handle(WorldIdPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                JourneymapClient.getInstance().getPacketHandler().onWorldIdReceived(packet.getWorldId());
            } else {
                Journeymap.getInstance().getPacketHandler().onWorldIdRequest(((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

