/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityImportWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final ServerWorld world;
    private final BlockPos pos;
    private final Direction facing;
    private final List<ItemEntity> entities;

    public ItemHandlerWorldEntityImportWrapper(ServerWorld world, BlockPos pos, Direction facing, boolean ignorePickupDelay) {
        this(world, pos, facing, new AxisAlignedBB(pos), ignorePickupDelay);
    }

    public ItemHandlerWorldEntityImportWrapper(ServerWorld world, BlockPos pos, Direction facing, AxisAlignedBB area, boolean ignorePickupDelay) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
        this.entities = world.func_175647_a(ItemEntity.class, area, input -> (ignorePickupDelay || !input.func_174874_s()) && input.func_70089_S());
    }

    public List<ItemEntity> getEntities() {
        return this.entities;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return this.entities.stream().map(ItemEntity::func_92059_d).iterator();
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return new FilteredIngredientCollectionIterator((Iterable)((Object)this), this.getComponent().getMatcher(), (Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 64 * this.entities.size();
    }

    public ItemStack insert(@Nonnull ItemStack ingredient, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    protected void postExtract(ItemEntity entity, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            entity.func_70106_y();
        } else {
            entity.func_92058_a(itemStack);
        }
        if (GeneralConfig.worldInteractionEvents) {
            this.world.func_217379_c(1000, this.pos, 0);
            this.world.func_217379_c(2000, this.pos.func_177972_a(this.facing.func_176734_d()), this.facing.func_176745_a());
        }
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Integer quantityFlag = (Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition();
        Integer subMatchCondition = (Integer)matcher.withoutCondition((Object)matchCondition, this.getComponent().getPrimaryQuantifier().getMatchCondition());
        List<ItemEntity> entities = this.entities;
        if (entities.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        for (ItemEntity entity : entities) {
            ItemStack itemStack = entity.func_92059_d();
            if (!matcher.matches((Object)prototype, (Object)itemStack, (Object)subMatchCondition) || matcher.hasCondition((Object)matchCondition, (Object)quantityFlag) && itemStack.func_190916_E() < prototype.func_190916_E()) continue;
            itemStack = itemStack.func_77946_l();
            ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)prototype.func_190916_E()));
            if (!simulate) {
                this.postExtract(entity, itemStack);
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        if (this.entities.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemEntity entity = this.entities.get(0);
        ItemStack itemStack = entity.func_92059_d();
        itemStack = itemStack.func_77946_l();
        ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)maxQuantity));
        if (!simulate) {
            this.postExtract(entity, itemStack);
        }
        return ret;
    }
}

