/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateEnergy<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IEnergyNetwork, Long>
implements IEnergyStorage {
    public PartStateEnergy(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, network, partNetwork, target);
    }

    protected IEnergyStorage getEnergyStorage() {
        return (IEnergyStorage)((IEnergyNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityEnergy.ENERGY, this.getChannel());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        maxReceive = Math.min(maxReceive, GeneralConfig.energyRateLimit);
        return this.canReceive() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testInsertion((Object)maxReceive) ? this.getEnergyStorage().receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        maxExtract = Math.min(maxExtract, GeneralConfig.energyRateLimit);
        return this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testExtraction((Object)maxExtract) ? this.getEnergyStorage().extractEnergy(maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        if (this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            int stored = this.getEnergyStorage().getEnergyStored();
            if (this.getStorageFilter().testView((Object)stored)) {
                return stored;
            }
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getEnergyStorage().getMaxEnergyStored() : 0;
    }
}

