/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import javax.annotation.Nonnull;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateFluid<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IFluidNetwork, FluidStack>
implements IFluidHandler {
    public PartStateFluid(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, network, partNetwork, target);
    }

    protected IFluidHandler getFluidHandler() {
        return (IFluidHandler)((IFluidNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getChannel());
    }

    public int getTanks() {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getFluidHandler().getTanks() : 0;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            FluidStack fluidStack = this.getFluidHandler().getFluidInTank(tank);
            if (this.getStorageFilter().testView((Object)fluidStack)) {
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getFluidHandler().getTankCapacity(tank) : 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testInsertion((Object)stack) && this.getFluidHandler().isFluidValid(tank, stack);
    }

    protected FluidStack rateLimitFluid(FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.getAmount() > GeneralConfig.fluidRateLimit) {
            return new FluidStack(fluidStack, GeneralConfig.fluidRateLimit);
        }
        return fluidStack;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.canReceive() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testInsertion((Object)resource) ? this.getFluidHandler().fill(this.rateLimitFluid(resource), action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testExtraction((Object)resource) ? this.getFluidHandler().drain(this.rateLimitFluid(resource), action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            FluidStack drainedSimulated;
            PositionedAddonsNetworkIngredientsFilter filter = this.getStorageFilter();
            if (action.execute() && !filter.testExtraction((Object)(drainedSimulated = this.getFluidHandler().drain(Math.min(maxDrain, GeneralConfig.fluidRateLimit), IFluidHandler.FluidAction.EXECUTE)))) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.getFluidHandler().drain(Math.min(maxDrain, GeneralConfig.fluidRateLimit), action);
            if (action.simulate() && !filter.testExtraction((Object)drained)) {
                return FluidStack.EMPTY;
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }
}

