/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PotionItem;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.container.PortableDankProvider;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.network.CMessageToggleUseType;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Mode;
import tfar.dankstorage.utils.Utils;

public class DankItem
extends Item {
    public final DankStats tier;
    public static final Rarity GRAY = Rarity.create((String)"dark_gray", (TextFormatting)TextFormatting.GRAY);
    public static final Rarity RED = Rarity.create((String)"red", (TextFormatting)TextFormatting.RED);
    public static final Rarity GOLD = Rarity.create((String)"gold", (TextFormatting)TextFormatting.GOLD);
    public static final Rarity GREEN = Rarity.create((String)"green", (TextFormatting)TextFormatting.GREEN);
    public static final Rarity BLUE = Rarity.create((String)"blue", (TextFormatting)TextFormatting.AQUA);
    public static final Rarity PURPLE = Rarity.create((String)"purple", (TextFormatting)TextFormatting.DARK_PURPLE);
    public static final Rarity WHITE = Rarity.create((String)"white", (TextFormatting)TextFormatting.WHITE);

    public DankItem(Item.Properties p_i48527_2_, DankStats stats) {
        super(p_i48527_2_);
        this.tier = stats;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(() -> Utils.getHandler(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    @Nonnull
    public Rarity func_77613_e(ItemStack stack) {
        switch (this.tier) {
            case one: {
                return GRAY;
            }
            case two: {
                return RED;
            }
            case three: {
                return GOLD;
            }
            case four: {
                return GREEN;
            }
            case five: {
                return BLUE;
            }
            case six: {
                return PURPLE;
            }
            case seven: {
                return WHITE;
            }
        }
        return super.func_77613_e(stack);
    }

    public int func_77626_a(ItemStack bag) {
        if (!Utils.isConstruction(bag)) {
            return 0;
        }
        ItemStack stack = Utils.getItemStackInSelectedSlot(bag);
        return stack.func_77973_b().func_77626_a(stack);
    }

    public Set<ToolType> getToolTypes(ItemStack bag) {
        if (!Utils.isConstruction(bag)) {
            return Sets.newHashSet();
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(bag);
        return tool.func_77973_b().getToolTypes(tool);
    }

    public int getHarvestLevel(ItemStack bag, ToolType p_getHarvestLevel_2_, @Nullable PlayerEntity p_getHarvestLevel_3_, @Nullable BlockState p_getHarvestLevel_4_) {
        if (!Utils.isConstruction(bag)) {
            return -1;
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(bag);
        return tool.getHarvestLevel(p_getHarvestLevel_2_, p_getHarvestLevel_3_, p_getHarvestLevel_4_);
    }

    public float func_150893_a(ItemStack bag, BlockState p_150893_2_) {
        if (!Utils.isConstruction(bag)) {
            return 1.0f;
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(bag);
        return tool.func_77973_b().func_150893_a(tool, p_150893_2_);
    }

    public boolean func_179218_a(ItemStack s, World p_179218_2_, BlockState p_179218_3_, BlockPos p_179218_4_, LivingEntity p_179218_5_) {
        if (!Utils.isConstruction(s)) {
            return super.func_179218_a(s, p_179218_2_, p_179218_3_, p_179218_4_, p_179218_5_);
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(s);
        return tool.func_77973_b().func_179218_a(tool, p_179218_2_, p_179218_3_, p_179218_4_, p_179218_5_);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack bag = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EquipmentSlotType hand1;
            if (Utils.getUseType(bag) == CMessageToggleUseType.UseType.bag) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new PortableDankProvider(bag, hand));
                return super.func_77659_a(world, player, hand);
            }
            ItemStack toPlace = Utils.getItemStackInSelectedSlot(bag);
            EquipmentSlotType equipmentSlotType = hand1 = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            if (toPlace.func_190926_b()) {
                return ActionResult.func_226250_c_((Object)bag);
            }
            if (toPlace.func_77973_b().func_219971_r()) {
                if (player.func_71043_e(false)) {
                    player.func_184598_c(hand);
                    return ActionResult.func_226249_b_((Object)bag);
                }
            } else {
                if (toPlace.func_77973_b() instanceof PotionItem) {
                    player.func_184598_c(hand);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
                }
                ItemStack newBag = bag.func_77946_l();
                player.func_184201_a(hand1, toPlace);
                ActionResult actionResult = toPlace.func_77973_b().func_77659_a(world, player, hand);
                PortableDankHandler handler = Utils.getHandler(newBag);
                handler.setStackInSlot(Utils.getSelectedSlot(newBag), (ItemStack)actionResult.func_188398_b());
                player.func_184201_a(hand1, newBag);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public ActionResultType func_111207_a(ItemStack bag, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!Utils.isConstruction(bag)) {
            return ActionResultType.FAIL;
        }
        PortableDankHandler handler = Utils.getHandler(bag);
        ItemStack toPlace = handler.getStackInSlot(Utils.getSelectedSlot(bag));
        EquipmentSlotType hand1 = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
        player.func_184201_a(hand1, toPlace);
        ActionResultType result = toPlace.func_77973_b().func_111207_a(toPlace, player, entity, hand);
        handler.setStackInSlot(Utils.getSelectedSlot(bag), toPlace);
        player.func_184201_a(hand1, bag);
        return result;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && Utils.getMode(stack) != Mode.normal;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack bag, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (bag.func_77942_o() && Utils.DEV) {
            tooltip.add((ITextComponent)new StringTextComponent(bag.func_77978_p().toString()));
        }
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.shift", new Object[]{new StringTextComponent("Shift").func_240699_a_(TextFormatting.YELLOW)}).func_240699_a_(TextFormatting.GRAY));
        }
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.changemode", new Object[]{Client.CONSTRUCTION.func_238171_j_().func_230531_f_().func_240699_a_(TextFormatting.YELLOW)}).func_240699_a_(TextFormatting.GRAY));
            CMessageToggleUseType.UseType mode = Utils.getUseType(bag);
            tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.currentusetype", new Object[]{new TranslationTextComponent("dankstorage.usetype." + mode.name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.YELLOW)}).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.stacklimit", new Object[]{new StringTextComponent(Utils.getStackLimit(bag) + "").func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.GRAY));
            PortableDankHandler handler = Utils.getHandler(bag);
            if (handler.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.empty").func_240699_a_(TextFormatting.ITALIC));
                return;
            }
            int count1 = 0;
            for (int i = 0; i < handler.getSlots() && count1 <= 10; ++i) {
                ItemStack item = handler.getStackInSlot(i);
                if (item.func_190926_b()) continue;
                IFormattableTextComponent count = new StringTextComponent(Integer.toString(item.func_190916_E())).func_240699_a_(TextFormatting.AQUA);
                ++count1;
            }
        }
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        if (!Utils.isConstruction(stack)) {
            return UseAction.NONE;
        }
        ItemStack internal = Utils.getItemStackInSelectedSlot(stack);
        return internal.func_77973_b().func_77661_b(stack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!Utils.isConstruction(stack)) {
            return stack;
        }
        ItemStack internal = Utils.getItemStackInSelectedSlot(stack);
        if (internal.func_77973_b().func_219971_r()) {
            ItemStack food = entity.func_213357_a(world, internal);
            PortableDankHandler handler = Utils.getHandler(stack);
            handler.setStackInSlot(Utils.getSelectedSlot(stack), food);
            return stack;
        }
        if (internal.func_77973_b() instanceof PotionItem) {
            ItemStack potion = internal.func_77950_b(world, entity);
            PortableDankHandler handler = Utils.getHandler(stack);
            handler.setStackInSlot(Utils.getSelectedSlot(stack), potion);
            return stack;
        }
        return super.func_77654_b(stack, world, entity);
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
    }

    public int getGlintColor(ItemStack stack) {
        Mode mode = Utils.getMode(stack);
        switch (mode) {
            default: {
                return -1;
            }
            case pickup_all: {
                return -16711936;
            }
            case filtered_pickup: {
                return -256;
            }
            case void_pickup: 
        }
        return -65536;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (((Boolean)DankStorage.ServerConfig.useShareTag.get()).booleanValue()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_150297_b("inv", 9)) {
                return nbt;
            }
            return Utils.copyNBTSkipKey(nbt, "inv");
        }
        return super.getShareTag(stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        int selectedSlot;
        ItemStack bag = ctx.func_195996_i();
        CMessageToggleUseType.UseType useType = Utils.getUseType(bag);
        if (useType == CMessageToggleUseType.UseType.bag) {
            return ActionResultType.PASS;
        }
        PortableDankHandler handler = Utils.getHandler(bag);
        ItemStack toPlace = handler.getStackInSlot(selectedSlot = Utils.getSelectedSlot(bag)).func_77946_l();
        if (toPlace.func_190916_E() == 1 && handler.isLocked(selectedSlot)) {
            return ActionResultType.PASS;
        }
        ItemStack safeCopy = bag.func_77946_l();
        ItemUseContextExt ctx2 = new ItemUseContextExt(ctx.func_195991_k(), ctx.func_195999_j(), ctx.func_221531_n(), toPlace, ctx.field_221535_d);
        ActionResultType actionResultType = toPlace.func_77973_b().func_195939_a((ItemUseContext)ctx2);
        handler.setStackInSlot(selectedSlot, ctx2.func_195996_i());
        return actionResultType;
    }

    public static class ItemUseContextExt
    extends ItemUseContext {
        protected ItemUseContextExt(World p_i50034_1_, @Nullable PlayerEntity p_i50034_2_, Hand p_i50034_3_, ItemStack p_i50034_4_, BlockRayTraceResult p_i50034_5_) {
            super(p_i50034_1_, p_i50034_2_, p_i50034_3_, p_i50034_4_, p_i50034_5_);
        }
    }
}

