/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import vazkii.quark.base.module.QuarkModule;

public enum ModuleCategory {
    AUTOMATION("automation", Items.field_151137_ax),
    BUILDING("building", Items.field_221647_bL),
    MANAGEMENT("management", Items.field_221675_bZ),
    TOOLS("tools", Items.field_151035_b),
    TWEAKS("tweaks", Items.field_205157_eZ),
    WORLD("world", Items.field_221581_i),
    MOBS("mobs", Items.field_196127_cN),
    CLIENT("client", Items.field_151061_bv),
    ODDITIES("oddities", Items.field_185161_cS, "quarkoddities"),
    EXPERIMENTAL("experimental", Items.field_221649_bM);

    public final String name;
    public final Item item;
    public final String requiredMod;
    public boolean enabled;
    private List<QuarkModule> ownedModules = new ArrayList<QuarkModule>();

    private ModuleCategory(String name, Item item, String requiredMod) {
        this.name = name;
        this.item = item;
        this.requiredMod = requiredMod;
        this.enabled = true;
    }

    private ModuleCategory(String name, Item item) {
        this(name, item, null);
    }

    public void addModule(QuarkModule module) {
        this.ownedModules.add(module);
    }

    public List<QuarkModule> getOwnedModules() {
        return this.ownedModules;
    }

    public boolean isAddon() {
        return this.requiredMod != null;
    }
}

