/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.util.TriFunction;

public class QuarkItemFrameItem
extends QuarkItem {
    private final TriFunction<? extends HangingEntity, World, BlockPos, Direction> entityProvider;

    public QuarkItemFrameItem(String name, QuarkModule module, TriFunction<? extends HangingEntity, World, BlockPos, Direction> entityProvider) {
        super(name, module, new Item.Properties().func_200916_a(ItemGroup.field_78031_c));
        this.entityProvider = entityProvider;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        BlockPos placeLocation = pos.func_177972_a(facing);
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (player != null && !this.canPlace(player, facing, stack, placeLocation)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        HangingEntity frame = this.entityProvider.apply(world, placeLocation, facing);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            EntityType.func_208048_a((World)world, (PlayerEntity)player, (Entity)frame, (CompoundNBT)tag);
        }
        if (frame.func_70518_d()) {
            if (!world.field_72995_K) {
                frame.func_184523_o();
                world.func_217376_c((Entity)frame);
            }
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    protected boolean canPlace(PlayerEntity player, Direction facing, ItemStack stack, BlockPos pos) {
        return !World.func_189509_E((BlockPos)pos) && player.func_175151_a(pos, facing, stack);
    }
}

