/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.client.tooltip.TooltipUtils;

public class AttributeTooltips {
    private static final Attribute MAX_HEALTH = Attributes.field_233818_a_;
    private static final Attribute KNOCKBACK_RESISTANCE = Attributes.field_233820_c_;
    private static final Attribute MOVEMENT_SPEED = Attributes.field_233821_d_;
    private static final Attribute ATTACK_DAMAGE = Attributes.field_233823_f_;
    private static final Attribute ATTACK_SPEED = Attributes.field_233825_h_;
    private static final Attribute ARMOR = Attributes.field_233826_i_;
    private static final Attribute ARMOR_TOUGHNESS = Attributes.field_233827_j_;
    private static final Attribute LUCK = Attributes.field_233828_k_;
    private static final Attribute REACH_DISTANCE = (Attribute)ForgeMod.REACH_DISTANCE.get();
    public static final ImmutableSet<Attribute> VALID_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_DAMAGE, (Object)ATTACK_SPEED, (Object)REACH_DISTANCE, (Object)ARMOR, (Object)ARMOR_TOUGHNESS, (Object)KNOCKBACK_RESISTANCE, (Object[])new Attribute[]{MAX_HEALTH, MOVEMENT_SPEED, LUCK});
    private static final ImmutableSet<Attribute> MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)MOVEMENT_SPEED);
    private static final ImmutableSet<Attribute> POTION_MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_SPEED);
    private static final ImmutableSet<Attribute> PERCENT_ATTRIBUTES = ImmutableSet.of((Object)KNOCKBACK_RESISTANCE, (Object)LUCK);
    private static final ImmutableSet<Attribute> DIFFERENCE_ATTRIBUTES = ImmutableSet.of((Object)MAX_HEALTH, (Object)REACH_DISTANCE);
    private static final ImmutableSet<Attribute> NONMAIN_DIFFERENCE_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_DAMAGE, (Object)ATTACK_SPEED);
    private static final UUID DUMMY_UUID = new UUID(0L, 0L);
    private static final AttributeModifier DUMMY_MODIFIER = new AttributeModifier(DUMMY_UUID, "NO-OP", 0.0, AttributeModifier.Operation.ADDITION);
    private static final ImmutableSet<String> ATTRIBUTE_FORMATS = ImmutableSet.of((Object)"plus", (Object)"take", (Object)"equals");

    private static String format(Attribute attribute, double value, EquipmentSlotType slot) {
        if (PERCENT_ATTRIBUTES.contains((Object)attribute)) {
            return (value > 0.0 ? "+" : "") + ItemStack.field_111284_a.format(value * 100.0) + "%";
        }
        if (MULTIPLIER_ATTRIBUTES.contains((Object)attribute) || slot == null && POTION_MULTIPLIER_ATTRIBUTES.contains((Object)attribute)) {
            return ItemStack.field_111284_a.format(value / AttributeTooltips.baseValue(attribute)) + "x";
        }
        if (DIFFERENCE_ATTRIBUTES.contains((Object)attribute) || slot != EquipmentSlotType.MAINHAND && NONMAIN_DIFFERENCE_ATTRIBUTES.contains((Object)attribute)) {
            return (value > 0.0 ? "+" : "") + ItemStack.field_111284_a.format(value);
        }
        return ItemStack.field_111284_a.format(value);
    }

    private static double baseValue(Attribute attribute) {
        if (attribute == MOVEMENT_SPEED) {
            return 0.1;
        }
        if (attribute == ATTACK_SPEED) {
            return 4.0;
        }
        if (attribute == MAX_HEALTH) {
            return 20.0;
        }
        return 1.0;
    }

    private static int renderPosition(Attribute attribute) {
        if (attribute == ATTACK_DAMAGE) {
            return 238;
        }
        if (attribute == ATTACK_SPEED) {
            return 247;
        }
        if (attribute == REACH_DISTANCE) {
            return 193;
        }
        if (attribute == ARMOR) {
            return 229;
        }
        if (attribute == ARMOR_TOUGHNESS) {
            return 220;
        }
        if (attribute == KNOCKBACK_RESISTANCE) {
            return 175;
        }
        if (attribute == MOVEMENT_SPEED) {
            return 184;
        }
        if (attribute == LUCK) {
            return 202;
        }
        return 211;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (!Screen.func_231173_s_()) {
            List tooltipRaw = event.getToolTip();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<Attribute, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            EquipmentSlotType[] slots = EquipmentSlotType.values();
            for (EquipmentSlotType slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                if (!AttributeTooltips.canStripAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (slot != null && allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty()) {
                    if (slot == null) {
                        allAreSame = false;
                    }
                    String slotDesc = slot == null ? "potion.whenDrank" : "item.modifiers." + slot.func_188450_d();
                    int index = -1;
                    for (int i = 0; i < tooltipRaw.size(); ++i) {
                        ITextComponent component = (ITextComponent)tooltipRaw.get(i);
                        if (!AttributeTooltips.equalsOrSibling(component, slotDesc)) continue;
                        index = i;
                        break;
                    }
                    if (index < 0) continue;
                    tooltipRaw.remove(index - 1);
                    tooltipRaw.remove(index - 1);
                }
                onlyInvalid = AttributeTooltips.extractAttributeValues(event, stack, tooltipRaw, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            EquipmentSlotType primarySlot = MobEntity.func_184640_d((ItemStack)stack);
            boolean showSlots = !allAreSame && (onlyInvalid || attributeTooltips.size() == 1 && attributeTooltips.containsKey(primarySlot));
            for (int i = 0; i < slots.length; ++i) {
                EquipmentSlotType slot;
                slot = slots[slots.length - (i + 1)];
                if (!attributeTooltips.containsKey(slot)) continue;
                String stringForSlot = ((StringBuilder)attributeTooltips.get(slot)).toString();
                int len = 16;
                if (stringForSlot.contains("/")) {
                    String[] toks;
                    stringForSlot = stringForSlot.substring(0, stringForSlot.length() - 1);
                    for (String tok : toks = stringForSlot.split("/")) {
                        len += mc.field_71466_p.func_78256_a(tok) + 5;
                    }
                }
                if (showSlots) {
                    len += 20;
                }
                String spaceStr = "";
                while (mc.field_71466_p.func_78256_a(spaceStr) < len) {
                    spaceStr = spaceStr + " ";
                }
                tooltipRaw.add(1, new StringTextComponent(spaceStr));
                if (allAreSame) break;
            }
        }
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, EquipmentSlotType slot) {
        if (slot == null) {
            List potions = PotionUtils.func_185189_a((ItemStack)stack);
            HashMultimap out = HashMultimap.create();
            for (EffectInstance potioneffect : potions) {
                Effect potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                for (Attribute attribute : map.keySet()) {
                    AttributeModifier baseModifier = (AttributeModifier)map.get(attribute);
                    AttributeModifier amplified = new AttributeModifier(baseModifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), baseModifier), baseModifier.func_220375_c());
                    out.put((Object)attribute, (Object)amplified);
                }
            }
            return out;
        }
        Multimap out = stack.func_111283_C(slot);
        out = out.isEmpty() ? HashMultimap.create() : HashMultimap.create((Multimap)out);
        if (slot == EquipmentSlotType.MAINHAND) {
            if (EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_) > 0.0f) {
                out.put((Object)ATTACK_DAMAGE, (Object)DUMMY_MODIFIER);
            }
            if (out.containsKey((Object)ATTACK_DAMAGE) && !out.containsKey((Object)ATTACK_SPEED)) {
                out.put((Object)ATTACK_SPEED, (Object)DUMMY_MODIFIER);
            } else if (out.containsKey((Object)ATTACK_SPEED) && !out.containsKey((Object)ATTACK_DAMAGE)) {
                out.put((Object)ATTACK_DAMAGE, (Object)DUMMY_MODIFIER);
            }
        }
        return out;
    }

    public static boolean extractAttributeValues(ItemTooltipEvent event, ItemStack stack, List<ITextComponent> tooltip, Map<EquipmentSlotType, StringBuilder> attributeTooltips, boolean onlyInvalid, EquipmentSlotType slot, Multimap<Attribute, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        block0: for (Attribute attr : slotAttributes.keySet()) {
            if (VALID_ATTRIBUTES.contains((Object)attr)) {
                onlyInvalid = false;
                double attributeValue = AttributeTooltips.getAttribute(event.getPlayer(), slot, stack, slotAttributes, attr);
                if (attributeValue != 0.0) {
                    if (!attributeTooltips.containsKey(slot)) {
                        attributeTooltips.put(slot, new StringBuilder());
                    }
                    attributeTooltips.get(slot).append(AttributeTooltips.format(attr, attributeValue, slot)).append("/");
                }
            } else if (!anyInvalid) {
                anyInvalid = true;
                if (!attributeTooltips.containsKey(slot)) {
                    attributeTooltips.put(slot, new StringBuilder());
                }
                attributeTooltips.get(slot).append("[+]");
            }
            for (int i = 1; i < tooltip.size(); ++i) {
                if (!AttributeTooltips.isAttributeLine(tooltip.get(i), attr)) continue;
                tooltip.remove(i);
                continue block0;
            }
        }
        return onlyInvalid;
    }

    private static TranslationTextComponent getMatchingOrSibling(ITextComponent component, String key) {
        if (component instanceof TranslationTextComponent) {
            return key.equals(((TranslationTextComponent)component).func_150268_i()) ? (TranslationTextComponent)component : null;
        }
        for (ITextComponent sibling : component.func_150253_a()) {
            if (!(sibling instanceof TranslationTextComponent)) continue;
            return AttributeTooltips.getMatchingOrSibling(sibling, key);
        }
        return null;
    }

    private static boolean equalsOrSibling(ITextComponent component, String key) {
        return AttributeTooltips.getMatchingOrSibling(component, key) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isAttributeLine(ITextComponent lineRaw, Attribute attr) {
        String attNamePattern = attr.func_233754_c_();
        for (String att : ATTRIBUTE_FORMATS) {
            for (int mod = 0; mod < 3; ++mod) {
                Object formatArg;
                Object[] formatArgs;
                String pattern = "attribute.modifier." + att + "." + mod;
                TranslationTextComponent line = AttributeTooltips.getMatchingOrSibling(lineRaw, pattern);
                if (line == null || (formatArgs = line.func_150271_j()).length <= 1 || !((formatArg = formatArgs[1]) instanceof ITextComponent) || !AttributeTooltips.equalsOrSibling((ITextComponent)formatArg, attNamePattern)) continue;
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int renderAttribute(MatrixStack matrix, Attribute attribute, EquipmentSlotType slot, int x, int y, ItemStack stack, Multimap<Attribute, AttributeModifier> slotAttributes, Minecraft mc) {
        double value = AttributeTooltips.getAttribute((PlayerEntity)mc.field_71439_g, slot, stack, slotAttributes, attribute);
        if (value != 0.0) {
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(MiscUtil.GENERAL_ICONS);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)AttributeTooltips.renderPosition(attribute), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            String valueStr = AttributeTooltips.format(attribute, value, slot);
            int color = value < 0.0 || valueStr.endsWith("x") && value / AttributeTooltips.baseValue(attribute) < 1.0 ? 0xFF5555 : 0xFFFFFF;
            mc.field_71466_p.func_238405_a_(matrix, valueStr, (float)(x + 12), (float)(y + 1), color);
            x += mc.field_71466_p.func_78256_a(valueStr) + 20;
        }
        return x;
    }

    private static EquipmentSlotType getPrimarySlot(ItemStack stack) {
        if (stack.func_77973_b() instanceof PotionItem || stack.func_77973_b() instanceof TippedArrowItem) {
            return null;
        }
        return MobEntity.func_184640_d((ItemStack)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        MatrixStack matrix = event.getMatrixStack();
        if (!Screen.func_231173_s_()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 500.0);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            matrix.func_227861_a_(0.0, 0.0, (double)mc.func_175599_af().field_77023_b);
            int baseX = event.getX();
            int y = TooltipUtils.shiftTextByLines(event.getLines(), event.getY() + 10);
            EquipmentSlotType primarySlot = AttributeTooltips.getPrimarySlot(stack);
            boolean onlyInvalid = true;
            boolean showSlots = false;
            int attributeHash = 0;
            boolean allAreSame = true;
            EquipmentSlotType[] slots = EquipmentSlotType.values();
            block0: for (EquipmentSlotType slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                if (!AttributeTooltips.canStripAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (slot == EquipmentSlotType.MAINHAND) {
                    attributeHash = slotAttributes.hashCode();
                } else if (allAreSame && attributeHash != slotAttributes.hashCode()) {
                    allAreSame = false;
                }
                for (Attribute attr : slotAttributes.keys()) {
                    if (!VALID_ATTRIBUTES.contains((Object)attr)) continue;
                    onlyInvalid = false;
                    if (slot == primarySlot) continue;
                    showSlots = true;
                    break block0;
                }
            }
            if (allAreSame) {
                showSlots = false;
            } else if (onlyInvalid) {
                showSlots = true;
            }
            for (EquipmentSlotType slot : slots) {
                if (!AttributeTooltips.canStripAttributes(stack, slot)) continue;
                int x = baseX;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                boolean anyToRender = false;
                for (Attribute attr : slotAttributes.keys()) {
                    double value = AttributeTooltips.getAttribute((PlayerEntity)mc.field_71439_g, slot, stack, slotAttributes, attr);
                    if (value == 0.0) continue;
                    anyToRender = true;
                    break;
                }
                if (!anyToRender) continue;
                if (showSlots) {
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(MiscUtil.GENERAL_ICONS);
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)(202 + (slot == null ? -1 : slot.ordinal()) * 9), (float)35.0f, (int)9, (int)9, (int)256, (int)256);
                    x += 20;
                }
                for (Attribute key : VALID_ATTRIBUTES) {
                    x = AttributeTooltips.renderAttribute(matrix, key, slot, x, y, stack, slotAttributes, mc);
                }
                for (Attribute key : slotAttributes.keys()) {
                    if (VALID_ATTRIBUTES.contains((Object)key)) continue;
                    mc.field_71466_p.func_238405_a_(matrix, "[+]", (float)(x + 1), (float)(y + 1), 0xFFFF55);
                    break;
                }
                y += 10;
                if (allAreSame) break;
            }
            matrix.func_227865_b_();
        }
    }

    private static boolean canStripAttributes(ItemStack stack, @Nullable EquipmentSlotType slot) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == null) {
            return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 0x20) == 0;
        }
        return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 2) == 0;
    }

    private static double getAttribute(PlayerEntity player, EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, Attribute key) {
        ModifiableAttributeInstance attribute;
        ModifiableAttributeInstance attribute2;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        if (!(PERCENT_ATTRIBUTES.contains((Object)key) || slot == null && key.equals(ATTACK_DAMAGE) || (attribute2 = player.func_110148_a(key)) == null)) {
            value = attribute2.func_111125_b();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.func_220375_c() != AttributeModifier.Operation.ADDITION) continue;
            value += modifier.func_111164_d();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            value += rawValue * modifier.func_111164_d();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            value += value * modifier.func_111164_d();
        }
        if (key.equals(ATTACK_DAMAGE) && slot == EquipmentSlotType.MAINHAND) {
            value += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        }
        if ((DIFFERENCE_ATTRIBUTES.contains((Object)key) || slot != EquipmentSlotType.MAINHAND && NONMAIN_DIFFERENCE_ATTRIBUTES.contains((Object)key)) && (slot != null || !key.equals(ATTACK_DAMAGE)) && (attribute = player.func_110148_a(key)) != null) {
            value -= attribute.func_111125_b();
        }
        return value;
    }
}

