/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.mobs.module.ForgottenModule;
import vazkii.quark.content.tools.module.ColorRunesModule;

public class ForgottenEntity
extends SkeletonEntity {
    public static final DataParameter<ItemStack> SHEATHED_ITEM = EntityDataManager.func_187226_a(ForgottenEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final ResourceLocation FORGOTTEN_LOOT_TABLE = new ResourceLocation("quark", "entities/forgotten");

    public ForgottenEntity(EntityType<? extends ForgottenEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEATHED_ITEM, (Object)ItemStack.field_190927_a);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_85036_m();
        return ilivingentitydata;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            boolean isUsingBow;
            boolean shouldUseBow;
            LivingEntity target = this.func_70638_az();
            boolean bl = shouldUseBow = target == null;
            if (!shouldUseBow) {
                EffectInstance eff = target.func_70660_b(Effects.field_76440_q);
                boolean bl2 = shouldUseBow = eff == null || eff.func_76459_b() < 20;
            }
            if (shouldUseBow != (isUsingBow = this.func_184614_ca().func_77973_b() instanceof BowItem)) {
                this.swap();
            }
        }
        double w = this.func_213311_cf() * 2.0f;
        double h = this.func_213302_cg();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + Math.random() * w - w / 2.0, this.func_226278_cu_() + Math.random() * h, this.func_226281_cx_() + Math.random() * w - w / 2.0, 0.0, 0.0, 0.0);
    }

    private void swap() {
        ItemStack curr = this.func_184614_ca();
        ItemStack off = (ItemStack)this.field_70180_af.func_187225_a(SHEATHED_ITEM);
        this.func_184611_a(Hand.MAIN_HAND, off);
        this.field_70180_af.func_187227_b(SHEATHED_ITEM, (Object)curr);
        Stream stream = this.field_70714_bg.func_220888_c();
        stream.map(PrioritizedGoal::func_220772_j).filter(g -> g instanceof MeleeAttackGoal || g instanceof RangedBowAttackGoal).forEach(Goal::func_75251_c);
        this.func_85036_m();
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return FORGOTTEN_LOOT_TABLE;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT sheathed = new CompoundNBT();
        ((ItemStack)this.field_70180_af.func_187225_a(SHEATHED_ITEM)).func_77955_b(sheathed);
        compound.func_218657_a("sheathed", (INBT)sheathed);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT sheathed = compound.func_74775_l("sheathed");
        this.field_70180_af.func_187227_b(SHEATHED_ITEM, (Object)ItemStack.func_199557_a((CompoundNBT)sheathed));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.1f;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.prepareEquipment();
    }

    public void prepareEquipment() {
        ItemStack bow = new ItemStack((IItemProvider)Items.field_151031_f);
        ItemStack sheathed = new ItemStack((IItemProvider)Items.field_151040_l);
        EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)bow, (int)20, (boolean)false);
        EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)sheathed, (int)20, (boolean)false);
        if (ModuleLoader.INSTANCE.isModuleEnabled(ColorRunesModule.class) && this.field_70146_Z.nextBoolean()) {
            List items = ColorRunesModule.runesLootableTag.func_230236_b_();
            ItemStack item = new ItemStack((IItemProvider)items.get(this.field_70146_Z.nextInt(items.size())));
            CompoundNBT runeNbt = item.serializeNBT();
            ItemNBTHelper.setBoolean((ItemStack)bow, (String)"quark:RuneAttached", (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)sheathed, (String)"quark:RuneAttached", (boolean)true);
            ItemNBTHelper.setCompound((ItemStack)bow, (String)"quark:RuneColor", (CompoundNBT)runeNbt);
            ItemNBTHelper.setCompound((ItemStack)sheathed, (String)"quark:RuneColor", (CompoundNBT)runeNbt);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, bow);
        this.field_70180_af.func_187227_b(SHEATHED_ITEM, (Object)sheathed);
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ForgottenModule.forgotten_hat));
    }

    protected AbstractArrowEntity func_213624_b(ItemStack arrowStack, float distanceFactor) {
        AbstractArrowEntity arrow = super.func_213624_b(arrowStack, distanceFactor);
        if (arrow instanceof ArrowEntity) {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_185167_i);
            PotionUtils.func_185184_a((ItemStack)stack, (Collection)ImmutableSet.of((Object)new EffectInstance(Effects.field_76440_q, 100, 0)));
            ((ArrowEntity)arrow).func_184555_a(stack);
        }
        return arrow;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

