/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.content.mobs.module.WraithModule;

public class WraithEntity
extends ZombieEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("quark:entities/wraith");
    private static final DataParameter<String> IDLE_SOUND = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> HURT_SOUND = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DEATH_SOUND = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final String TAG_IDLE_SOUND = "IdleSound";
    private static final String TAG_HURT_SOUND = "HurtSound";
    private static final String TAG_DEATH_SOUND = "DeathSound";

    public WraithEntity(EntityType<? extends WraithEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IDLE_SOUND, (Object)"");
        this.field_70180_af.func_187214_a(HURT_SOUND, (Object)"");
        this.field_70180_af.func_187214_a(DEATH_SOUND, (Object)"");
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233829_l_, 0.0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    protected SoundEvent func_184639_G() {
        return this.getSound(IDLE_SOUND);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return this.getSound(HURT_SOUND);
    }

    protected SoundEvent func_184615_bR() {
        return this.getSound(DEATH_SOUND);
    }

    protected float func_70647_i() {
        return this.field_70146_Z.nextFloat() * 0.1f + 0.75f;
    }

    public SoundEvent getSound(DataParameter<String> param) {
        ResourceLocation loc = new ResourceLocation((String)this.field_70180_af.func_187225_a(param));
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(loc);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        AxisAlignedBB aabb = this.func_174813_aQ();
        double x = aabb.field_72340_a + Math.random() * (aabb.field_72336_d - aabb.field_72340_a);
        double y = aabb.field_72338_b + Math.random() * (aabb.field_72337_e - aabb.field_72338_b);
        double z = aabb.field_72339_c + Math.random() * (aabb.field_72334_f - aabb.field_72339_c);
        this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197596_G, x, y, z, 0.0, 0.0, 0.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean did = super.func_70652_k(entityIn);
        if (did) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1));
            }
            double dx = this.func_226277_ct_() - entityIn.func_226277_ct_();
            double dz = this.func_226281_cx_() - entityIn.func_226281_cx_();
            Vector3d vec = new Vector3d(dx, 0.0, dz).func_72432_b().func_72441_c(0.0, 0.5, 0.0).func_72432_b().func_186678_a(0.85);
            this.func_213317_d(vec);
        }
        return did;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        int idx = this.field_70146_Z.nextInt(WraithModule.validWraithSounds.size());
        String sound = WraithModule.validWraithSounds.get(idx);
        String[] split = sound.split("\\|");
        this.field_70180_af.func_187227_b(IDLE_SOUND, (Object)split[0]);
        this.field_70180_af.func_187227_b(HURT_SOUND, (Object)split[1]);
        this.field_70180_af.func_187227_b(DEATH_SOUND, (Object)split[2]);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a(TAG_IDLE_SOUND, (String)this.field_70180_af.func_187225_a(IDLE_SOUND));
        compound.func_74778_a(TAG_HURT_SOUND, (String)this.field_70180_af.func_187225_a(HURT_SOUND));
        compound.func_74778_a(TAG_DEATH_SOUND, (String)this.field_70180_af.func_187225_a(DEATH_SOUND));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IDLE_SOUND, (Object)compound.func_74779_i(TAG_IDLE_SOUND));
        this.field_70180_af.func_187227_b(HURT_SOUND, (Object)compound.func_74779_i(TAG_HURT_SOUND));
        this.field_70180_af.func_187227_b(DEATH_SOUND, (Object)compound.func_74779_i(TAG_DEATH_SOUND));
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void func_82227_f(boolean childZombie) {
    }

    public boolean func_70631_g_() {
        return false;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.func_203417_a(WraithModule.wraithSpawnableTag) ? 1.0f : 0.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!super.func_70097_a(source, amount)) {
            return false;
        }
        return this.field_70170_p instanceof ServerWorld;
    }

    protected void func_207304_a(float difficulty) {
    }
}

