/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlimeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.quark.base.handler.OverrideRegistryHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.util.MutableVectorHolder;
import vazkii.quark.content.tweaks.block.SpringySlimeBlock;

@LoadModule(category=ModuleCategory.TWEAKS)
public class SpringySlimeModule
extends QuarkModule {
    private static final ThreadLocal<MutableVectorHolder> motionRecorder = ThreadLocal.withInitial(MutableVectorHolder::new);

    @Override
    public void construct() {
        SpringySlimeBlock block = new SpringySlimeBlock();
        OverrideRegistryHandler.registerBlock((Block)block, "slime_block", ItemGroup.field_78031_c);
    }

    public static void recordMotion(Entity entity) {
        motionRecorder.get().importFrom(entity.func_213322_ci());
    }

    public static void collideWithSlimeBlock(BlockPos pos, Entity entity) {
        if (entity instanceof AbstractArrowEntity && ModuleLoader.INSTANCE.isModuleEnabled(SpringySlimeModule.class)) {
            Vector3d motion = entity.func_213322_ci();
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72448_b;
            double motionZ = motion.field_72449_c;
            Vector3d epos = entity.func_213303_ch();
            Direction sideHit = Direction.func_176737_a((float)((float)(epos.field_72450_a + motionX) - ((float)pos.func_177958_n() + 0.5f)), (float)((float)(epos.field_72448_b + motionY) - ((float)pos.func_177956_o() + 0.5f)), (float)((float)(epos.field_72449_c + motionZ) - ((float)pos.func_177952_p() + 0.5f)));
            switch (sideHit.func_176740_k()) {
                case X: {
                    if (Math.abs(motionX) < 0.1) {
                        return;
                    }
                    motionX = 0.8 * Math.min(Math.abs(motionX), 0.25) * (double)sideHit.func_82601_c();
                    break;
                }
                case Y: {
                    if (Math.abs(motionY) < 0.1) {
                        return;
                    }
                    motionY = 0.8 * Math.min(Math.abs(motionY), 0.25) * (double)sideHit.func_96559_d();
                    break;
                }
                case Z: {
                    if (Math.abs(motionZ) < 0.1) {
                        return;
                    }
                    motionZ = 0.8 * Math.min(Math.abs(motionZ), 0.25) * (double)sideHit.func_82599_e();
                }
            }
            entity.func_213293_j(motionX, motionY, motionZ);
            ((AbstractArrowEntity)entity).field_70254_i = true;
        }
    }

    public static void onEntityCollision(Entity entity, Vector3d attempted, Vector3d actual) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(SpringySlimeModule.class)) {
            return;
        }
        if (entity.func_226273_bm_() || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
            return;
        }
        double attemptedX = attempted.field_72450_a;
        double attemptedY = attempted.field_72448_b;
        double attemptedZ = attempted.field_72449_c;
        double dX = actual.field_72450_a;
        double dY = actual.field_72448_b;
        double dZ = actual.field_72449_c;
        double height = entity.func_213302_cg();
        double width = entity.func_213311_cf();
        Vector3d pos = entity.func_213303_ch();
        double minX = pos.field_72450_a - width / 2.0;
        double minY = pos.field_72448_b;
        double minZ = pos.field_72449_c - width / 2.0;
        double maxX = pos.field_72450_a + width / 2.0;
        double maxY = pos.field_72448_b + height;
        double maxZ = pos.field_72449_c + width / 2.0;
        if (attemptedX != dX) {
            SpringySlimeModule.applyForAxis(entity, Direction.Axis.X, minX, minY, minZ, maxX, maxY, maxZ, dX, attemptedX);
        }
        if (attemptedY != dY) {
            SpringySlimeModule.applyForAxis(entity, Direction.Axis.Y, minX, minY, minZ, maxX, maxY, maxZ, dY, attemptedY);
        }
        if (attemptedZ != dZ) {
            SpringySlimeModule.applyForAxis(entity, Direction.Axis.Z, minX, minY, minZ, maxX, maxY, maxZ, dZ, attemptedZ);
        }
    }

    private static double axial(Direction.Axis axis, double we, double ud, double ns) {
        switch (axis) {
            case X: {
                return we;
            }
            case Y: {
                return ud;
            }
        }
        return ns;
    }

    private static void applyForAxis(Entity entity, Direction.Axis axis, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double dV, double attemptedV) {
        double baseValue = dV < 0.0 ? SpringySlimeModule.axial(axis, minX, minY, minZ) : SpringySlimeModule.axial(axis, maxX, maxY, maxZ);
        double clampedAttempt = attemptedV;
        if (Math.abs(attemptedV) > Math.abs(dV) + 1.0) {
            clampedAttempt = dV + Math.signum(dV);
        }
        double v1 = baseValue + dV;
        double v2 = baseValue + clampedAttempt;
        double minV = Math.min(v1, v2);
        double maxV = Math.max(v1, v2);
        Direction impactedSide = Direction.func_181076_a((Direction.AxisDirection)(dV < 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE), (Direction.Axis)axis);
        int lowXBound = (int)Math.floor(SpringySlimeModule.axial(axis, minV, minX, minX));
        int highXBound = (int)Math.floor(SpringySlimeModule.axial(axis, maxV, maxX, maxX));
        int lowYBound = (int)Math.floor(SpringySlimeModule.axial(axis, minY, minV, minY));
        int highYBound = (int)Math.floor(SpringySlimeModule.axial(axis, maxY, maxV, maxY));
        int lowZBound = (int)Math.floor(SpringySlimeModule.axial(axis, minZ, minZ, minV));
        int highZBound = (int)Math.floor(SpringySlimeModule.axial(axis, maxZ, maxZ, maxV));
        boolean restoredZ = false;
        for (BlockPos position : BlockPos.func_191531_b((int)lowXBound, (int)lowYBound, (int)lowZBound, (int)highXBound, (int)highYBound, (int)highZBound)) {
            restoredZ = SpringySlimeModule.applyCollision(entity, position, impactedSide, restoredZ);
        }
    }

    private static boolean applyCollision(Entity entity, BlockPos position, Direction impacted, boolean restoredMotion) {
        BlockState state = entity.field_70170_p.func_180495_p(position);
        if (SpringySlimeModule.isSlime(state)) {
            if (impacted == Direction.UP && entity instanceof ItemEntity) {
                entity.func_230245_c_(false);
            }
            Vector3d motion = entity.func_213322_ci();
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72448_b;
            double motionZ = motion.field_72449_c;
            switch (impacted.func_176740_k()) {
                case X: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        motionX = SpringySlimeModule.motionRecorder.get().x;
                    }
                    motionX = Math.abs(motionX) * (double)impacted.func_82601_c();
                    if (entity instanceof LivingEntity) break;
                    motionX *= 0.8;
                    break;
                }
                case Y: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        motionY = SpringySlimeModule.motionRecorder.get().y;
                    }
                    motionY = Math.abs(motionY) * (double)impacted.func_96559_d();
                    if (entity instanceof LivingEntity) break;
                    motionY *= 0.8;
                    break;
                }
                case Z: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        motionZ = SpringySlimeModule.motionRecorder.get().z;
                    }
                    motionZ = Math.abs(motionZ) * (double)impacted.func_82599_e();
                    if (entity instanceof LivingEntity) break;
                    motionZ *= 0.8;
                }
            }
            entity.func_213293_j(motionX, motionY, motionZ);
        }
        return restoredMotion;
    }

    private static boolean isSlime(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof SlimeBlock;
    }
}

