/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.common.Tags;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.world.module.DeepslateModule;

public class DeepslateSheetGenerator
extends Generator {
    private static final long PERLIN_MAP_SEED = 185954371487L;
    private final PerlinNoiseGenerator noiseGenerator = new PerlinNoiseGenerator(new SharedSeedRandom(185954371487L), IntStream.rangeClosed(-4, 4));

    public DeepslateSheetGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(0, 0, 0);
        for (int i = 0; i < 16; ++i) {
            mutable.func_223471_o(pos.func_177958_n() + i);
            for (int j = 0; j < 16; ++j) {
                mutable.func_223472_q(pos.func_177952_p() + j);
                int start = DeepslateModule.sheetYStart;
                int end = start + DeepslateModule.sheetHeight;
                double noise = this.noiseGenerator.func_215464_a((double)mutable.func_177958_n(), (double)mutable.func_177952_p(), false);
                end = (int)((long)end + Math.round(noise * (double)DeepslateModule.sheetHeightVariance));
                for (int k = start; k <= end; ++k) {
                    mutable.func_185336_p(k);
                    BlockState stateAt = worldIn.func_180495_p((BlockPos)mutable);
                    boolean canPlace = true;
                    if (stateAt.func_177230_c() != Blocks.field_150348_b) continue;
                    for (Direction d : Direction.values()) {
                        stateAt = worldIn.func_180495_p(mutable.func_177972_a(d));
                        if (!stateAt.func_177230_c().func_203417_a((ITag)Tags.Blocks.ORES)) continue;
                        canPlace = false;
                        break;
                    }
                    if (!canPlace) continue;
                    worldIn.func_180501_a((BlockPos)mutable, (k == end ? DeepslateModule.smooth_basalt : DeepslateModule.deepslate).func_176223_P(), 0);
                }
            }
        }
    }
}

