/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.ModData;
import al132.alib.client.CapabilityDisplayWrapper;
import al132.alib.client.CapabilityEnergyDisplayWrapper;
import al132.alib.client.CapabilityFluidDisplayWrapper;
import al132.alib.container.ABaseContainer;
import al132.alib.tiles.GuiTile;
import al132.alib.utils.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ABaseScreen<T extends ABaseContainer>
extends ContainerScreen<T> {
    protected ResourceLocation GUI;
    T screenContainer;
    protected List<CapabilityDisplayWrapper> displayData = new ArrayList<CapabilityDisplayWrapper>();
    ResourceLocation powerBarTexture;

    public ABaseScreen(ModData data, T screenContainer, PlayerInventory inv, ITextComponent name, String path) {
        super(screenContainer, inv, name);
        this.powerBarTexture = new ResourceLocation(data.MODID, "textures/gui/template.png");
        this.screenContainer = screenContainer;
        this.field_146999_f = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getWidth();
        this.field_147000_g = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getHeight();
        this.GUI = new ResourceLocation(data.MODID, path);
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int relY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(ms, relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.displayData.forEach(data -> {
            if (data instanceof CapabilityEnergyDisplayWrapper) {
                this.drawPowerBar(ms, (CapabilityEnergyDisplayWrapper)data, this.powerBarTexture, 0, 0);
            } else if (data instanceof CapabilityFluidDisplayWrapper) {
                this.drawFluidTank((CapabilityFluidDisplayWrapper)data, relX + data.x, relY + data.y);
            }
        });
    }

    protected void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        String displayName = ((ABaseContainer)((Object)this.screenContainer)).tile.func_145748_c_().getString();
        ABaseScreen.func_238476_c_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)displayName, (int)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(displayName) / 2), (int)-10, (int)Color.WHITE.getRGB());
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.displayData.stream().filter(data -> mouseX >= data.x + x && mouseX <= data.x + x + data.width && mouseY >= data.y + y && mouseY <= data.y + y + data.height).forEach(it -> this.func_238652_a_(ms, it.toTextComponent(), mouseX, mouseY));
    }

    public int getBarScaled(int pixels, int count, int max) {
        if (count > 0 && max > 0) {
            return count * pixels / max;
        }
        return 0;
    }

    public void drawPowerBar(MatrixStack ms, CapabilityEnergyDisplayWrapper storage, ResourceLocation texture, int textureX, int textureY) {
        if (storage.getStored() > 0) {
            int i = storage.x + (this.field_230708_k_ - this.field_146999_f) / 2;
            int j = storage.y + (this.field_230709_l_ - this.field_147000_g) / 2;
            int k = this.getBarScaled(storage.height, storage.getStored(), storage.getCapacity());
            this.getMinecraft().field_71446_o.func_110577_a(texture);
            this.func_238474_b_(ms, i, j + storage.height - k, textureX, textureY, storage.width, k);
            this.getMinecraft().field_71446_o.func_110577_a(this.GUI);
        }
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j) {
        this.drawFluidTank(wrapper, i, j, 16, 60);
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j, int width, int height) {
        if (wrapper.getStored() > 5) {
            RenderUtils.bindBlockTexture();
            RenderUtils.renderGuiTank(wrapper.fluid.get().getFluidInTank(0), wrapper.getCapacity(), wrapper.getStored(), i, j, this.func_230927_p_(), width, height);
        }
    }

    public void bindWidgets() {
        this.getMinecraft().field_71446_o.func_110577_a(new ResourceLocation("alib", "textures/gui/widgets.png"));
    }

    public void drawRightArrow(MatrixStack ms, int x, int y, int width) {
        int height = 9;
        this.bindWidgets();
        this.func_238474_b_(ms, x, y, 0, 120, width, height);
    }

    public void drawDownArrow(MatrixStack ms, int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.func_238474_b_(ms, x, y, 9, 129, width, height);
    }

    public void drawUpArrow(MatrixStack ms, int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.func_238474_b_(ms, x, y, 0, 129, width, height);
    }
}

