/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.client.CapabilityDisplayWrapper;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CapabilityFluidDisplayWrapper
extends CapabilityDisplayWrapper {
    public static NumberFormat numFormat = NumberFormat.getInstance(Locale.US);
    public Supplier<IFluidHandler> fluid;

    public CapabilityFluidDisplayWrapper(int x, int y, int width, int height, Supplier<IFluidHandler> fluid) {
        super(x, y, width, height);
        this.fluid = fluid;
    }

    @Override
    public int getStored() {
        return this.fluid.get().getFluidInTank(0).getAmount();
    }

    @Override
    public int getCapacity() {
        return this.fluid.get().getTankCapacity(0);
    }

    public String toString() {
        FluidStack stack = this.fluid.get().getFluidInTank(0);
        String fluidName = "";
        String stored = numFormat.format(this.getStored());
        String capacity = numFormat.format(this.getCapacity());
        if (!stack.isEmpty() && stack.getAmount() > 0) {
            fluidName = I18n.func_135052_a((String)stack.getFluid().getAttributes().getTranslationKey(), (Object[])new Object[0]);
        }
        String out = stored + "/" + capacity + " mb " + fluidName;
        return out;
    }
}

