/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.compat.jei;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendRecipe {
    private ItemStackList stacks;
    private BlockPos pos;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            buf.func_150788_a(stack);
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(PacketBuffer buf) {
        int l = buf.readInt();
        this.stacks = ItemStackList.create((int)l);
        for (int i = 0; i < l; ++i) {
            this.stacks.set(i, (Object)buf.func_150791_c());
        }
        this.pos = buf.readBoolean() ? buf.func_179259_c() : null;
    }

    public PacketSendRecipe(ItemStackList stacks, BlockPos pos) {
        this.stacks = stacks;
        this.pos = pos;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            ServerPlayerEntity player = ctx.getSender();
            World world = player.func_130014_f_();
            if (this.pos != null && (te = world.func_175625_s(this.pos)) instanceof JEIRecipeAcceptor) {
                JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                acceptor.setGridContents((List)this.stacks);
            }
        });
        ctx.setPacketHandled(true);
    }
}

