/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class PotionEffectModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private final Effect potion;
    private final int amplifier;
    private boolean active = false;
    private int ticks = 180;

    public PotionEffectModule(String potionname, int amplifier) {
        this.potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionname));
        this.amplifier = amplifier;
    }

    protected abstract PlayerBuff getBuff();

    protected boolean allowedForPlayers() {
        return true;
    }

    @Override
    public void tick(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        EnvironmentalControllerTileEntity.EnvironmentalMode mode = controllerTileEntity.getMode();
        switch (mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                if (!this.allowedForPlayers()) break;
                this.processPlayers(world, pos, radius, miny, maxy, controllerTileEntity);
                break;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                this.processEntities(world, pos, radius, miny, maxy, controllerTileEntity);
            }
        }
    }

    private void processPlayers(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.func_217369_A());
        for (PlayerEntity player : players) {
            double py = player.func_226278_cu_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.func_226277_ct_();
            double pz = player.func_226281_cx_();
            double sqdist = (px - (double)pos.func_177958_n()) * (px - (double)pos.func_177958_n()) + (pz - (double)pos.func_177952_p()) * (pz - (double)pos.func_177952_p());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            player.func_195064_c(new EffectInstance(this.potion, 540, this.amplifier, true, false));
            PlayerBuff buff = this.getBuff();
            if (buff == null) continue;
            BuffProperties.addBuffToPlayer(player, buff, 180);
        }
    }

    private void processEntities(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        List entities = world.func_217394_a((EntityType)null, new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - radius), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + radius), (double)(pos.func_177952_p() + radius)), e -> e instanceof LivingEntity);
        for (LivingEntity entity : entities) {
            PlayerBuff buff;
            double py = entity.func_226278_cu_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = entity.func_226277_ct_();
            double pz = entity.func_226281_cx_();
            double sqdist = (px - (double)pos.func_177958_n()) * (px - (double)pos.func_177958_n()) + (pz - (double)pos.func_177952_p()) * (pz - (double)pos.func_177952_p());
            if (!(sqdist < maxsqdist)) continue;
            if (controllerTileEntity.isEntityAffected((Entity)entity)) {
                if (entity instanceof PlayerEntity && !this.allowedForPlayers()) continue;
                entity.func_195064_c(new EffectInstance(this.potion, 540, this.amplifier, true, false));
                buff = this.getBuff();
                if (buff == null || !(entity instanceof PlayerEntity)) continue;
                BuffProperties.addBuffToPlayer((PlayerEntity)entity, buff, 180);
                continue;
            }
            if (!(entity instanceof PlayerEntity) || (buff = this.getBuff()) == null) continue;
            BuffProperties.addBuffToPlayer((PlayerEntity)entity, buff, 180);
        }
    }

    @Override
    public boolean apply(World world, BlockPos pos, LivingEntity entity, int duration) {
        entity.func_195064_c(new EffectInstance(this.potion, duration, this.amplifier, true, false));
        return true;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick, final Supplier<Boolean> isAllowed) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }

            @Override
            protected boolean allowedForPlayers() {
                return (Boolean)isAllowed.get();
            }
        };
    }
}

