/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public enum ScreenDataType {
    TYPE_NULL,
    TYPE_BYTE,
    TYPE_INT,
    TYPE_LONG,
    TYPE_DOUBLE,
    TYPE_FLOAT,
    TYPE_STRING,
    TYPE_BOOLEAN,
    TYPE_ITEMSTACK,
    TYPE_COLOREDTEXT;


    public Object readObject(PacketBuffer buf) {
        switch (this) {
            case TYPE_NULL: {
                return null;
            }
            case TYPE_BYTE: {
                return buf.readByte();
            }
            case TYPE_INT: {
                return buf.readInt();
            }
            case TYPE_LONG: {
                return buf.readLong();
            }
            case TYPE_DOUBLE: {
                return buf.readDouble();
            }
            case TYPE_FLOAT: {
                return Float.valueOf(buf.readFloat());
            }
            case TYPE_BOOLEAN: {
                return buf.readBoolean();
            }
            case TYPE_STRING: {
                return buf.func_150789_c(Short.MAX_VALUE);
            }
            case TYPE_ITEMSTACK: {
                return NetworkTools.readItemStack((PacketBuffer)buf);
            }
            case TYPE_COLOREDTEXT: {
                return null;
            }
        }
        return null;
    }

    public static void writeObject(PacketBuffer buf, Object obj) {
        if (obj == null) {
            buf.writeByte(TYPE_NULL.ordinal());
        } else if (obj instanceof Long) {
            buf.writeByte(TYPE_LONG.ordinal());
            buf.writeLong(((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            buf.writeByte(TYPE_INT.ordinal());
            buf.writeInt(((Integer)obj).intValue());
        } else if (obj instanceof Byte) {
            buf.writeByte(TYPE_BYTE.ordinal());
            buf.writeByte((int)((Byte)obj).byteValue());
        } else if (obj instanceof Float) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeDouble(((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            buf.writeByte(TYPE_BOOLEAN.ordinal());
            buf.writeBoolean(((Boolean)obj).booleanValue());
        } else if (obj instanceof String) {
            buf.writeByte(TYPE_STRING.ordinal());
            String s = (String)obj;
            buf.writeInt(s.length());
            buf.writeBytes(s.getBytes());
        } else if (obj instanceof ItemStack) {
            buf.writeByte(TYPE_ITEMSTACK.ordinal());
            NetworkTools.writeItemStack((PacketBuffer)buf, (ItemStack)((ItemStack)obj));
        } else {
            Logging.log((String)"Weird ScreenDataType!");
        }
    }
}

