/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenLevelHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnergyBarClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    protected DimensionId dim = DimensionId.overworld();
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private ITextRenderHelper labelCache = new ScreenTextHelper();
    private ILevelRenderHelper rfRenderer = new ScreenLevelHelper().gradient(-65536, -13421824);

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(matrixStack, buffer, 0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            this.rfRenderer.render(matrixStack, buffer, xoffset, currenty, screenData, renderInfo);
        } else {
            renderHelper.renderText(matrixStack, buffer, xoffset, currenty, 0xFF0000, renderInfo, "<invalid>");
        }
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            int rfcolor = tagCompound.func_74764_b("rfcolor") ? tagCompound.func_74762_e("rfcolor") : 0xFFFFFF;
            int rfcolorNeg = tagCompound.func_74764_b("rfcolor_neg") ? tagCompound.func_74762_e("rfcolor_neg") : 0xFFFFFF;
            this.rfRenderer.color(rfcolor, rfcolorNeg);
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get((String)alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            boolean hidebar = tagCompound.func_74767_n("hidebar");
            boolean hidetext = tagCompound.func_74767_n("hidetext");
            boolean showdiff = tagCompound.func_74767_n("showdiff");
            boolean showpct = tagCompound.func_74767_n("showpct");
            this.rfRenderer.settings(hidebar, hidetext, showpct, showdiff);
            this.rfRenderer.format(FormatStyle.getStyle((String)tagCompound.func_74779_i("format")));
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

