/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.IModuleGuiChanged;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScreenModuleGuiBuilder
implements IModuleGuiBuilder {
    private Minecraft mc;
    private Screen gui;
    private CompoundNBT currentData;
    private IModuleGuiChanged moduleGuiChanged;
    private Panel panel;
    private List<Widget<?>> row = new ArrayList();

    public ScreenModuleGuiBuilder(Minecraft mc, Screen gui, CompoundNBT currentData, IModuleGuiChanged moduleGuiChanged) {
        this.gui = gui;
        this.mc = mc;
        this.moduleGuiChanged = moduleGuiChanged;
        this.currentData = currentData;
        this.panel = Widgets.vertical((int)3, (int)1);
    }

    public CompoundNBT getCurrentData() {
        return this.currentData;
    }

    public World getWorld() {
        return this.mc.field_71439_g.func_130014_f_();
    }

    public Panel build() {
        this.nl();
        return this.panel;
    }

    public ScreenModuleGuiBuilder label(String text) {
        this.row.add((Widget<?>)Widgets.label((String)text));
        return this;
    }

    public ScreenModuleGuiBuilder leftLabel(String text) {
        this.row.add((Widget<?>)Widgets.label((String)text).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        return this;
    }

    public ScreenModuleGuiBuilder text(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField().desiredHeight(15)).tooltips(tooltip)).event(newText -> {
            this.currentData.func_74778_a(tagname, newText);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null) {
            textField.text(this.currentData.func_74779_i(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder integer(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField().desiredHeight(15)).tooltips(tooltip)).event(newText -> {
            int value;
            try {
                value = Integer.parseInt(newText);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.currentData.func_74768_a(tagname, value);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null && this.currentData.func_74764_b(tagname)) {
            int dd = this.currentData.func_74762_e(tagname);
            textField.text(Integer.toString(dd));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().text(label)).tooltips(tooltip)).desiredHeight(14)).checkMarker(true);
        toggleButton.event(() -> {
            this.currentData.func_74757_a(tagname, toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.pressed(this.currentData.func_74767_n(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().text(label)).tooltips(tooltip)).desiredHeight(14)).desiredWidth(36)).checkMarker(true);
        toggleButton.event(() -> {
            this.currentData.func_74757_a(tagname, !toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.pressed(!this.currentData.func_74767_n(tagname));
        } else {
            toggleButton.pressed(true);
        }
        return this;
    }

    public ScreenModuleGuiBuilder color(String tagname, String ... tooltip) {
        int currentColor;
        ColorSelector colorSelector = ((ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector().tooltips(tooltip)).desiredWidth(20)).desiredHeight(14)).event(newColor -> {
            this.currentData.func_74768_a(tagname, newColor.intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)colorSelector);
        if (this.currentData != null && (currentColor = this.currentData.func_74762_e(tagname)) != 0) {
            colorSelector.currentColor(Integer.valueOf(currentColor));
        }
        return this;
    }

    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        String currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().tooltips(new String[]{tooltip})).desiredWidth(50)).desiredHeight(14);
        for (String s : choices) {
            choiceLabel.choices(new String[]{s});
        }
        choiceLabel.event(newChoice -> {
            this.currentData.func_74778_a(tagname, newChoice);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && !(currentChoice = this.currentData.func_74779_i(tagname)).isEmpty()) {
            choiceLabel.choice(currentChoice);
        }
        return this;
    }

    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        int currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(14);
        HashMap<String, Integer> choicesMap = new HashMap<String, Integer>(choices.length);
        for (int i = 0; i < choices.length; ++i) {
            IModuleGuiBuilder.Choice c = choices[i];
            String name = c.getName();
            choicesMap.put(name, i);
            choiceLabel.choices(new String[]{name});
            choiceLabel.choiceTooltip(name, c.getTooltips());
        }
        choiceLabel.event(newChoice -> {
            this.currentData.func_74768_a(tagname, ((Integer)choicesMap.get(newChoice)).intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && (currentChoice = this.currentData.func_74762_e(tagname)) < choices.length && currentChoice >= 0) {
            choiceLabel.choice(choices[currentChoice].getName());
        }
        return this;
    }

    public ScreenModuleGuiBuilder format(String tagname) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupFormatCombo(this.mc, this.gui, tagname, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    public ScreenModuleGuiBuilder mode(String componentName) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupModeCombo(this.mc, this.gui, componentName, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    public ScreenModuleGuiBuilder block(String tagnamePos) {
        String monitoring;
        if (this.currentData.func_74764_b(tagnamePos + "x")) {
            World world;
            ResourceLocation dim = this.currentData.func_74764_b(tagnamePos + "dim") ? new ResourceLocation(this.currentData.func_74779_i(tagnamePos + "dim")) : new ResourceLocation(this.currentData.func_74779_i("dim"));
            if (dim.equals((Object)DimensionId.fromWorld((World)(world = this.getWorld())).getRegistryName())) {
                int x = this.currentData.func_74762_e(tagnamePos + "x");
                int y = this.currentData.func_74762_e(tagnamePos + "y");
                int z = this.currentData.func_74762_e(tagnamePos + "z");
                monitoring = this.currentData.func_74779_i(tagnamePos + "name");
                Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                this.row.add((Widget<?>)new BlockRender().renderItem((Object)block).desiredWidth(20));
                this.row.add((Widget<?>)((Label)Widgets.label((String)(x + "," + y + "," + z)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        this.row.add((Widget<?>)Widgets.label((String)monitoring));
        return this;
    }

    public IModuleGuiBuilder ghostStack(final String tagname) {
        ItemStack stack = ItemStack.field_190927_a;
        if (this.currentData.func_74764_b(tagname)) {
            stack = ItemStack.func_199557_a((CompoundNBT)this.currentData.func_74775_l(tagname));
        }
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender().renderItem((Object)stack).desiredWidth(18)).desiredHeight(18)).filledRectThickness(1)).filledBackground(-11184811);
        this.row.add((Widget<?>)blockRender);
        blockRender.event(new BlockRenderEvent(){

            public void select() {
                ItemStack holding = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                if (holding.func_190926_b()) {
                    ScreenModuleGuiBuilder.this.currentData.func_82580_o(tagname);
                    blockRender.renderItem(null);
                } else {
                    ItemStack copy = holding.func_77946_l();
                    copy.func_190920_e(1);
                    blockRender.renderItem((Object)copy);
                    CompoundNBT tc = new CompoundNBT();
                    copy.func_77955_b(tc);
                    ScreenModuleGuiBuilder.this.currentData.func_218657_a(tagname, (INBT)tc);
                }
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }

            public void doubleClick() {
            }
        });
        return this;
    }

    public ScreenModuleGuiBuilder nl() {
        if (this.row.size() == 1) {
            this.panel.children(new Widget[]{this.row.get(0).desiredHeight(16)});
            this.row.clear();
        } else if (!this.row.isEmpty()) {
            Panel rowPanel = (Panel)Widgets.horizontal().desiredHeight(16);
            for (Widget<?> widget : this.row) {
                rowPanel.children(new Widget[]{widget});
            }
            this.panel.children(new Widget[]{rowPanel});
            this.row.clear();
        }
        return this;
    }

    private static ChoiceLabel setupFormatCombo(Minecraft mc, Screen gui, String tagname, CompoundNBT currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeFull = FormatStyle.MODE_FULL.getName();
        String modeCompact = FormatStyle.MODE_COMPACT.getName();
        String modeCommas = FormatStyle.MODE_COMMAS.getName();
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(58)).desiredHeight(14)).choices(new String[]{modeFull, modeCompact, modeCommas}).choiceTooltip(modeFull, new String[]{"Full format: 3123555"}).choiceTooltip(modeCompact, new String[]{"Compact format: 3.1M"}).choiceTooltip(modeCommas, new String[]{"Comma format: 3,123,555"}).event(newChoice -> {
            currentData.func_74778_a(tagname, FormatStyle.getStyle((String)newChoice).getName());
            moduleGuiChanged.updateData();
        });
        FormatStyle currentFormat = FormatStyle.getStyle((String)currentData.func_74779_i(tagname));
        modeButton.choice(currentFormat.getName());
        return modeButton;
    }

    private static ChoiceLabel setupModeCombo(Minecraft mc, Screen gui, String componentName, CompoundNBT currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeNone = "None";
        String modePertick = componentName + "/t";
        String modePct = componentName + "%";
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(14)).choices(new String[]{modeNone, componentName, modePertick, modePct}).choiceTooltip(modeNone, new String[]{"No text is shown"}).choiceTooltip(componentName, new String[]{"Show the amount of " + componentName}).choiceTooltip(modePertick, new String[]{"Show the average " + componentName + "/tick", "gain or loss"}).choiceTooltip(modePct, new String[]{"Show the amount of " + componentName, "as a percentage"}).event(newChoice -> {
            if (componentName.equals(newChoice)) {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", false);
            } else if (modePertick.equals(newChoice)) {
                currentData.func_74757_a("showdiff", true);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", false);
            } else if (modePct.equals(newChoice)) {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", true);
                currentData.func_74757_a("hidetext", false);
            } else {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", true);
            }
            moduleGuiChanged.updateData();
        });
        if (currentData.func_74767_n("hidetext")) {
            modeButton.choice(modeNone);
        } else if (currentData.func_74767_n("showdiff")) {
            modeButton.choice(modePertick);
        } else if (currentData.func_74767_n("showpct")) {
            modeButton.choice(modePct);
        } else {
            modeButton.choice(componentName);
        }
        return modeButton;
    }
}

