/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.tank.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.CustomTank;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.tank.TankConfiguration;
import mcjty.rftoolsutility.modules.tank.TankModule;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TankTE
extends GenericTileEntity {
    public static final int SLOT_FILTER = 0;
    public static final ModelProperty<Integer> AMOUNT = new ModelProperty();
    public static final ModelProperty<Fluid> FLUID = new ModelProperty();
    private int amount = -1;
    private Fluid clientFluid = null;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof BucketItem).in().out(), "container", 0, 151, 10).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<CustomTank> fluidHandler = LazyOptional.of(this::createFluidHandler);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Tank").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)TankModule.CONTAINER_TANK.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items));
    private Fluid filterFluid = null;

    public TankTE() {
        super((TileEntityType)TankModule.TYPE_TANK.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).tileEntitySupplier(TankTE::new).manualEntry(ManualHelper.create((String)"rftoolsutility:machines/tank")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"contents", stack -> TankTE.getFluidString(stack) + " (" + Integer.toString((Integer)TankConfiguration.MAXCAPACITY.get()) + " mb)")})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidString(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)info.func_74775_l(s));
            if (fluid.isEmpty()) {
                return "<empty>";
            }
            return fluid.getAmount() + "mb " + fluid.getDisplayName().getString();
        }, (String)"tank", (Object)"<empty");
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.amount = tagCompound.func_74762_e("level");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("level", this.amount);
        return super.func_189515_b(tagCompound);
    }

    protected void readCaps(CompoundNBT tagCompound) {
        super.readCaps(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.fluidHandler.ifPresent(h -> {
            h.readFromNBT(info.func_74775_l("tank"));
            this.clientFluid = h.getFluid().getFluid();
        });
        this.updateFilterFluid(this.items.getStackInSlot(0));
    }

    private void updateFilterFluid(ItemStack stack) {
        this.filterFluid = FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getFluid).orElse(null);
    }

    protected void writeCaps(CompoundNBT tagCompound) {
        super.writeCaps(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        this.fluidHandler.ifPresent(h -> {
            CompoundNBT nbt = new CompoundNBT();
            h.writeToNBT(nbt);
            info.func_218657_a("tank", (INBT)nbt);
        });
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof BucketItem;
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof BucketItem;
            }

            protected void onUpdate(int index) {
                super.onUpdate(index);
                TankTE.this.updateFilterFluid(this.getStackInSlot(0));
            }
        };
    }

    public ActionResultType onBlockActivated(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!this.field_145850_b.field_72995_K) {
            return this.fluidHandler.map(h -> {
                ItemStack heldItem = player.func_184586_b(hand);
                FluidActionResult fillResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)h, null, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
                if (fillResult.isSuccess()) {
                    player.func_184611_a(hand, fillResult.getResult());
                    return ActionResultType.SUCCESS;
                }
                fillResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)h, null, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
                if (fillResult.isSuccess()) {
                    player.func_184611_a(hand, fillResult.getResult());
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }).orElse(ActionResultType.PASS);
        }
        return ActionResultType.PASS;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.fluidHandler.ifPresent(tank -> {
            int oldLevel = this.computeLevel((CustomTank)tank);
            super.onDataPacket(net, packet);
            this.amount = this.computeLevel((CustomTank)tank);
            if (oldLevel != this.amount || !tank.getFluid().getFluid().equals(this.clientFluid)) {
                this.clientFluid = tank.getFluid().getFluid();
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        });
    }

    private void updateLevel(CustomTank tank) {
        this.markDirtyQuick();
        int newlevel = this.computeLevel(tank);
        if (this.amount != newlevel || !tank.getFluid().getFluid().equals(this.clientFluid)) {
            this.amount = newlevel;
            this.clientFluid = tank.getFluid().getFluid();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    private int computeLevel(CustomTank tank) {
        int amount = tank.getFluidAmount();
        if (amount <= 0) {
            return 0;
        }
        int total = 8 * amount / tank.getCapacity() + 1;
        if (total > 8) {
            total = 8;
        }
        return total;
    }

    private CustomTank createFluidHandler() {
        return new CustomTank((Integer)TankConfiguration.MAXCAPACITY.get()){

            protected void onContentsChanged() {
                TankTE.this.updateLevel(this);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (TankTE.this.filterFluid == null) {
                    return true;
                }
                return TankTE.this.filterFluid == stack.getFluid();
            }
        };
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(AMOUNT, (Object)this.amount).withInitial(FLUID, (Object)this.clientFluid).build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

