/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.tank.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.rftoolsutility.modules.tank.blocks.TankTE;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;

public class TankBakedModel
extends AbstractDynamicBakedModel {
    public static final ResourceLocation TEXTURE_TOP = new ResourceLocation("rftoolsbase", "block/base/machinetop");
    public static final ResourceLocation TEXTURE_BOTTOM = new ResourceLocation("rftoolsbase", "block/base/machinebottom");
    private static TextureAtlasSprite levelMask;

    private static TextureAtlasSprite getTopTexture() {
        return TankBakedModel.getTexture((ResourceLocation)TEXTURE_TOP);
    }

    private static TextureAtlasSprite getBottomTexture() {
        return TankBakedModel.getTexture((ResourceLocation)TEXTURE_BOTTOM);
    }

    private static TextureAtlasSprite getSideTexture(Integer level) {
        String name = "block/tank" + (level == null || level < 0 ? 0 : level);
        return TankBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsutility", name));
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        ResourceLocation stillTexture;
        if (side != null) {
            return Collections.emptyList();
        }
        Integer level = (Integer)data.getData(TankTE.AMOUNT);
        Fluid fluid = (Fluid)data.getData(TankTE.FLUID);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float hilight = 1.0f;
        quads.add(this.createQuad(TankBakedModel.v((double)0.0, (double)1.0, (double)0.0), TankBakedModel.v((double)0.0, (double)1.0, (double)1.0), TankBakedModel.v((double)1.0, (double)1.0, (double)1.0), TankBakedModel.v((double)1.0, (double)1.0, (double)0.0), TankBakedModel.getTopTexture(), hilight));
        quads.add(this.createQuad(TankBakedModel.v((double)0.0, (double)0.0, (double)0.0), TankBakedModel.v((double)1.0, (double)0.0, (double)0.0), TankBakedModel.v((double)1.0, (double)0.0, (double)1.0), TankBakedModel.v((double)0.0, (double)0.0, (double)1.0), TankBakedModel.getBottomTexture(), hilight));
        quads.add(this.createQuad(TankBakedModel.v((double)1.0, (double)1.0, (double)1.0), TankBakedModel.v((double)1.0, (double)0.0, (double)1.0), TankBakedModel.v((double)1.0, (double)0.0, (double)0.0), TankBakedModel.v((double)1.0, (double)1.0, (double)0.0), TankBakedModel.getSideTexture(level), hilight));
        quads.add(this.createQuad(TankBakedModel.v((double)0.0, (double)1.0, (double)0.0), TankBakedModel.v((double)0.0, (double)0.0, (double)0.0), TankBakedModel.v((double)0.0, (double)0.0, (double)1.0), TankBakedModel.v((double)0.0, (double)1.0, (double)1.0), TankBakedModel.getSideTexture(level), hilight));
        quads.add(this.createQuad(TankBakedModel.v((double)1.0, (double)1.0, (double)0.0), TankBakedModel.v((double)1.0, (double)0.0, (double)0.0), TankBakedModel.v((double)0.0, (double)0.0, (double)0.0), TankBakedModel.v((double)0.0, (double)1.0, (double)0.0), TankBakedModel.getSideTexture(level), hilight));
        quads.add(this.createQuad(TankBakedModel.v((double)0.0, (double)1.0, (double)1.0), TankBakedModel.v((double)0.0, (double)0.0, (double)1.0), TankBakedModel.v((double)1.0, (double)0.0, (double)1.0), TankBakedModel.v((double)1.0, (double)1.0, (double)1.0), TankBakedModel.getSideTexture(level), hilight));
        if (fluid != null && (stillTexture = fluid.getAttributes().getStillTexture()) != null) {
            TextureAtlasSprite fluidTexture = TankBakedModel.getTexture((ResourceLocation)stillTexture);
            int color = fluid.getAttributes().getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float o = 0.01f;
            double left = 0.25;
            double right = 0.56;
            double top = 0.505;
            double bottom = 0.81;
            quads.add(this.createQuad(TankBakedModel.v((double)(1.0f + o), (double)bottom, (double)(1.0 - right)), TankBakedModel.v((double)(1.0f + o), (double)bottom, (double)(1.0 - left)), TankBakedModel.v((double)(1.0f + o), (double)top, (double)(1.0 - left)), TankBakedModel.v((double)(1.0f + o), (double)top, (double)(1.0 - right)), fluidTexture, r, g, b, 1.0f));
            quads.add(this.createQuad(TankBakedModel.v((double)(-o), (double)bottom, (double)right), TankBakedModel.v((double)(-o), (double)bottom, (double)left), TankBakedModel.v((double)(-o), (double)top, (double)left), TankBakedModel.v((double)(-o), (double)top, (double)right), fluidTexture, r, g, b, 1.0f));
            quads.add(this.createQuad(TankBakedModel.v((double)(1.0 - right), (double)bottom, (double)(-o)), TankBakedModel.v((double)(1.0 - left), (double)bottom, (double)(-o)), TankBakedModel.v((double)(1.0 - left), (double)top, (double)(-o)), TankBakedModel.v((double)(1.0 - right), (double)top, (double)(-o)), fluidTexture, r, g, b, 1.0f));
            quads.add(this.createQuad(TankBakedModel.v((double)right, (double)bottom, (double)(1.0f + o)), TankBakedModel.v((double)left, (double)bottom, (double)(1.0f + o)), TankBakedModel.v((double)left, (double)top, (double)(1.0f + o)), TankBakedModel.v((double)right, (double)top, (double)(1.0f + o)), fluidTexture, r, g, b, 1.0f));
        }
        return quads;
    }

    public TextureAtlasSprite func_177554_e() {
        return TankBakedModel.getSideTexture(0);
    }
}

