/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class SimpleDialerTileEntity
extends LogicTileEntity {
    private GlobalCoordinate transmitter;
    private Integer receiver;
    private boolean onceMode = false;
    private boolean prevIn = false;

    public SimpleDialerTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_SIMPLE_DIALER.get());
    }

    public void update() {
        if (this.transmitter == null) {
            return;
        }
        if (this.powerLevel > 0 == this.prevIn) {
            return;
        }
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (this.powerLevel > 0) {
            int dial;
            GlobalCoordinate gc;
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            BlockPos coordinate = null;
            DimensionId dim = DimensionId.overworld();
            if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                coordinate = gc.getCoordinate();
                dim = gc.getDimension();
            }
            if ((dial = TeleportationTools.dial(this.func_145831_w(), null, null, this.transmitter.getCoordinate(), this.transmitter.getDimension(), coordinate, dim, this.onceMode)) != 0) {
                // empty if block
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.markDirtyClient();
    }

    public GlobalCoordinate getTransmitter() {
        return this.transmitter;
    }

    public Integer getReceiver() {
        return this.receiver;
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (info.func_74764_b("transX")) {
            String transDim = info.func_74779_i("transDim");
            this.transmitter = new GlobalCoordinate(new BlockPos(info.func_74762_e("transX"), info.func_74762_e("transY"), info.func_74762_e("transZ")), DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(transDim)));
        } else {
            this.transmitter = null;
        }
        this.receiver = info.func_74764_b("receiver") ? Integer.valueOf(info.func_74762_e("receiver")) : null;
        this.onceMode = info.func_74767_n("once");
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.transmitter != null) {
            info.func_74768_a("transX", this.transmitter.getCoordinate().func_177958_n());
            info.func_74768_a("transY", this.transmitter.getCoordinate().func_177956_o());
            info.func_74768_a("transZ", this.transmitter.getCoordinate().func_177952_p());
            info.func_74778_a("transDim", this.transmitter.getDimension().getRegistryName().toString());
        }
        if (this.receiver != null) {
            info.func_74768_a("receiver", this.receiver.intValue());
        }
        info.func_74757_a("once", this.onceMode);
    }
}

