/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.network.PacketGetAllReceivers;
import mcjty.rftoolsutility.setup.CommandHandler;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;

public class GuiTeleportProbe
extends Screen {
    private int xSize = 356;
    private int ySize = 180;
    private Window window;
    private WidgetList list;
    private static List<TeleportDestinationClientInfo> serverDestinationList = null;
    private static List<TeleportDestinationClientInfo> destinationList = null;
    private int listDirty = 0;

    public GuiTeleportProbe() {
        super((ITextComponent)new StringTextComponent("Teleport Probe"));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize) / 2;
        this.list = ((WidgetList)new WidgetList().name("list")).event((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(int index) {
                GuiTeleportProbe.this.teleport(index);
            }
        });
        Slider listSlider = ((Slider)new Slider().desiredWidth(11)).vertical().scrollableName("list");
        Panel toplevel = (Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.list, listSlider});
        toplevel.bounds(k, l, this.xSize, this.ySize);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        serverDestinationList = null;
        destinationList = null;
        this.requestReceiversFromServer();
    }

    private void teleport(int index) {
        TeleportDestinationClientInfo destination = destinationList.get(index);
        BlockPos c = destination.getCoordinate();
        RFToolsUtilityMessages.sendToServer("forceTeleport", TypedMap.builder().put(CommandHandler.PARAM_DIMENSION, (Object)destination.getDimension().getRegistryName().toString()).put(CommandHandler.PARAM_POS, (Object)c));
    }

    public static void setReceivers(List<TeleportDestinationClientInfo> destinationList) {
        serverDestinationList = new ArrayList<TeleportDestinationClientInfo>(destinationList);
    }

    private void requestReceiversFromServer() {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetAllReceivers());
    }

    private void populateList() {
        if (serverDestinationList == null) {
            return;
        }
        if (serverDestinationList.equals(destinationList)) {
            return;
        }
        destinationList = new ArrayList<TeleportDestinationClientInfo>(serverDestinationList);
        this.list.removeChildren();
        for (TeleportDestinationClientInfo destination : destinationList) {
            BlockPos coordinate = destination.getCoordinate();
            DimensionId dim = destination.getDimension();
            Panel panel = Widgets.horizontal();
            panel.children(new Widget[]{((Label)((Label)Widgets.label((String)destination.getName()).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(100), ((Label)((Label)Widgets.label((String)BlockPosTools.toString((BlockPos)coordinate)).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(75), ((Label)((Label)Widgets.label((String)("Id " + dim)).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(75)});
            this.list.children(new Widget[]{panel});
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int xSize_lo, int ySize_lo, float par3) {
        super.func_230430_a_(matrixStack, xSize_lo, ySize_lo, par3);
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.window.draw(matrixStack);
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int x = GuiTools.getRelativeX((Screen)this);
            int y = GuiTools.getRelativeY((Screen)this);
            int guiLeft = (this.field_230708_k_ - this.xSize) / 2;
            int guiTop = (this.field_230709_l_ - this.ySize) / 2;
            List properties = tooltips.stream().map(StringTextComponent::new).collect(Collectors.toList());
            List processors = LanguageMap.func_74808_a().func_244260_a(properties);
            this.func_238654_b_(matrixStack, processors, x - guiLeft, y - guiTop);
        }
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiTeleportProbe());
    }
}

